/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.id;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.iternine.jeppetto.dao.id.IdGenerator;

public class BaseNIdGenerator
implements IdGenerator<String> {
    public static final char[] BASE62_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] BASE36_CHARACTERS = Arrays.copyOfRange(BASE62_CHARACTERS, 0, 36);
    public static final char[] BASE16_CHARACTERS = Arrays.copyOfRange(BASE62_CHARACTERS, 0, 16);
    public static final char[] BASE10_CHARACTERS = Arrays.copyOfRange(BASE62_CHARACTERS, 0, 10);
    private static final int BITS_PER_LONG = 64;
    private final int bitsPerId;
    private final char[] characters;
    private final int base;
    private final int encodedIdLength;

    public BaseNIdGenerator(int bitsPerId, char[] characters) {
        if (bitsPerId < 1) {
            throw new IllegalArgumentException("bitsPerId must be >= 1");
        }
        if (characters == null || characters.length < 2) {
            throw new IllegalArgumentException("characters must be non-null and have at least two values");
        }
        this.bitsPerId = bitsPerId;
        this.characters = characters;
        this.base = characters.length;
        this.encodedIdLength = (int)Math.ceil((double)bitsPerId / (Math.log(this.base) / Math.log(2.0)));
    }

    @Override
    public String generateId() {
        StringBuilder sb = new StringBuilder();
        for (int bitsLeft = this.bitsPerId; bitsLeft > 0; bitsLeft -= 64) {
            long random = ThreadLocalRandom.current().nextLong();
            if (bitsLeft < 64) {
                random >>>= 64 - bitsLeft;
            }
            this.encode(random, sb);
        }
        while (sb.length() < this.encodedIdLength) {
            sb.append(this.characters[0]);
        }
        return sb.length() == this.encodedIdLength ? sb.toString() : sb.substring(0, this.encodedIdLength);
    }

    private void encode(long bits, StringBuilder sb) {
        if (bits < 0L) {
            sb.append(this.characters[(int)((bits % (long)this.base + (long)this.base) % (long)this.base)]);
            bits /= (long)(-this.base);
        }
        while (bits > 0L) {
            sb.append(this.characters[(int)(bits % (long)this.base)]);
            bits /= (long)this.base;
        }
    }
}

