/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.persistable;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.persistable.Persistable;

public class PersistableMap
implements Persistable,
Map<String, Object> {
    private Map<String, Object> delegate;
    private Set<String> updatedKeys = new HashSet<String>();
    private String storeIdentifier;

    public PersistableMap() {
        this(new HashMap<String, Object>());
    }

    public PersistableMap(int initialCapacity) {
        this(new HashMap<String, Object>(initialCapacity));
    }

    public PersistableMap(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean __isDirty() {
        return !this.updatedKeys.isEmpty() || this.__getDirtyFields().hasNext();
    }

    @Override
    public void __markPersisted(String storeIdentifier) {
        this.updatedKeys.clear();
        for (Map.Entry<String, Object> o : this.delegate.entrySet()) {
            Map.Entry<String, Object> entry = o;
            if (this.updatedKeys.contains(entry.getKey()) || !(entry.getValue() instanceof Persistable)) continue;
            Persistable persistable = (Persistable)entry.getValue();
            persistable.__markPersisted(storeIdentifier);
        }
        this.storeIdentifier = storeIdentifier;
    }

    @Override
    public boolean __isPersisted(String storeIdentifier) {
        return storeIdentifier.equals(this.storeIdentifier);
    }

    @Override
    public Iterator<String> __getDirtyFields() {
        return new Iterator<String>(){
            private Iterator<String> keysIterator;
            private String key;
            {
                HashSet allKeys = new HashSet(PersistableMap.this.delegate.keySet());
                allKeys.addAll(PersistableMap.this.updatedKeys);
                this.keysIterator = allKeys.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.keysIterator.hasNext()) {
                    this.key = this.keysIterator.next();
                    if (PersistableMap.this.updatedKeys.contains(this.key)) {
                        return true;
                    }
                    Object value = PersistableMap.this.delegate.get(this.key);
                    if (!(value instanceof Persistable) || !((Persistable)value).__isDirty() && ((Persistable)value).__isPersisted(PersistableMap.this.storeIdentifier)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                return this.key;
            }

            @Override
            public void remove() {
                throw new JeppettoException("Can't remove items from dirtyFields");
            }
        };
    }

    @Override
    public Object __getDelegate() {
        return this.delegate;
    }

    @Override
    public Object put(String key, Object value) {
        this.updatedKeys.add(key);
        return this.delegate.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        String stringKey = (String)key;
        Object result = this.delegate.remove(stringKey);
        if (result != null) {
            this.updatedKeys.add(stringKey);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.updatedKeys.clear();
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object value = this.delegate.get(key);
        return value;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    private Iterator<Map.Entry<String, Object>> delegateIterator;
                    private String currentKey;
                    {
                        this.delegateIterator = PersistableMap.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        Map.Entry<String, Object> current = this.delegateIterator.next();
                        return current;
                    }

                    @Override
                    public void remove() {
                        PersistableMap.this.remove(this.currentKey);
                    }
                };
            }

            @Override
            public int size() {
                return PersistableMap.this.delegate.size();
            }

            @Override
            public boolean remove(Object o) {
                return PersistableMap.this.remove(o) != null;
            }

            @Override
            public void clear() {
                PersistableMap.this.clear();
            }
        };
    }
}

