/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.updateobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.updateobject.UpdateObject;

public class UpdateList
implements UpdateObject,
List {
    private Map<String, Object> updates = new TreeMap<String, Object>();
    private List<Object> adds = new ArrayList<Object>();
    private boolean cleared = false;
    private String indexFormat;

    public UpdateList(String indexFormat) {
        this.indexFormat = indexFormat;
    }

    @Override
    public Map<String, Object> __getUpdates() {
        return this.updates;
    }

    public Object set(int index, Object element) {
        if (this.cleared) {
            throw new JeppettoException("set() after clear() not supported");
        }
        return this.updates.put(String.format(this.indexFormat, index), element);
    }

    @Override
    public boolean add(Object element) {
        return this.adds.add(element);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.adds.addAll(collection);
    }

    public Object remove(int index) {
        if (this.cleared) {
            throw new JeppettoException("remove(index) after clear() not supported");
        }
        return this.updates.put(String.format(this.indexFormat, index), null);
    }

    @Override
    public void clear() {
        this.cleared = true;
        this.updates.clear();
    }

    public void add(int index, Object element) {
        throw new JeppettoException("Can't add() an item to an UpdateList at a specific index");
    }

    public boolean addAll(int index, Collection elements) {
        throw new JeppettoException("Can't addAll() items to an UpdateList at a specific index");
    }

    @Override
    public boolean remove(Object element) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int size() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean isEmpty() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean contains(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Iterator iterator() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Object[] toArray() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public Object[] toArray(Object[] objects) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public boolean containsAll(Collection objects) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public Object get(int index) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int indexOf(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public ListIterator listIterator() {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public ListIterator listIterator(int index) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public List subList(int fromIndex, int toIndex) {
        throw new JeppettoException("An UpdateList does not support query operations.");
    }

    public boolean wasCleared() {
        return this.cleared;
    }

    public List<Object> getAdds() {
        return this.adds;
    }
}

