/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.enhance;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.iternine.jeppetto.enhance.ClassLoadingUtil;
import org.iternine.jeppetto.enhance.Enhancer;
import org.iternine.jeppetto.enhance.ExceptionUtil;
import org.iternine.jeppetto.enhance.TemplateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VelocityEnhancer<T>
extends Enhancer<T> {
    private static VelocityEngine engine;
    private static ClassPool pool;
    private static Logger logger;

    public VelocityEnhancer(Class<T> baseClass) {
        super(baseClass);
    }

    protected abstract String getTemplateLocation();

    @Override
    public final Class<? extends T> enhanceClass(Class<T> baseClass) {
        logger.info("Enhancing {}", baseClass);
        CtClass original = null;
        try {
            original = pool.get(baseClass.getName());
            TemplateHelper templateHelper = new TemplateHelper(pool);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("_", (Object)templateHelper);
            velocityContext.put("base", (Object)original);
            velocityContext.put("getters", (Object)this.findGetters(original));
            velocityContext.put("abstractMethods", (Object)this.findAbstractMethods(original));
            StringWriter writer = new StringWriter();
            engine.getTemplate(this.getTemplateLocation()).merge((Context)velocityContext, (Writer)writer);
            logger.debug("Enhanced {} to form new class {} with source:\n{}", new Object[]{baseClass.getSimpleName(), templateHelper.clsName(), writer});
            Class clazz = ClassLoadingUtil.toClass(templateHelper.compile());
            return clazz;
        }
        catch (Exception e) {
            logger.error("An error occurred while enhancing {}", baseClass);
            throw ExceptionUtil.propagate(e);
        }
        finally {
            if (original != null) {
                original.detach();
            }
        }
    }

    private Iterable<CtMethod> getMethodsFrom(CtClass superClass) {
        ArrayList<CtMethod> methods = new ArrayList<CtMethod>();
        methods.addAll(Arrays.asList(superClass.getDeclaredMethods()));
        methods.addAll(Arrays.asList(superClass.getMethods()));
        return methods;
    }

    private CtMethod[] findGetters(CtClass superClass) throws NotFoundException {
        ArrayList<CtMethod> getters = new ArrayList<CtMethod>();
        String objectFullName = Object.class.getName();
        HashSet<String> handledMethods = new HashSet<String>();
        for (CtMethod originalMethod : this.getMethodsFrom(superClass)) {
            boolean methodIsGetter;
            String methodName = originalMethod.getName();
            boolean bl = methodIsGetter = methodName.startsWith("get") || methodName.startsWith("is");
            if (handledMethods.contains(methodName) || !methodIsGetter || originalMethod.getDeclaringClass().getName().equals(objectFullName) || Modifier.isFinal(originalMethod.getModifiers()) || Modifier.isAbstract(originalMethod.getModifiers()) || originalMethod.getParameterTypes().length != 0 || !this.setterExists(superClass, this.extractFieldName(methodName))) continue;
            handledMethods.add(methodName);
            getters.add(originalMethod);
        }
        return getters.toArray(new CtMethod[getters.size()]);
    }

    private CtMethod[] findAbstractMethods(CtClass superClass) {
        ArrayList<CtMethod> abstractMethods = new ArrayList<CtMethod>();
        for (CtMethod originalMethod : this.getMethodsFrom(superClass)) {
            if (!Modifier.isAbstract(originalMethod.getModifiers())) continue;
            abstractMethods.add(originalMethod);
        }
        return abstractMethods.toArray(new CtMethod[abstractMethods.size()]);
    }

    private String extractFieldName(String from) {
        String sub = from.startsWith("is") ? from.substring(2) : from.substring(3);
        if (sub.length() > 1) {
            return sub.substring(0, 1).toLowerCase().concat(sub.substring(1));
        }
        return sub.toLowerCase();
    }

    private boolean setterExists(CtClass cls, String fieldName) {
        String name = fieldName.length() > 1 ? "set".concat(fieldName.substring(0, 1).toUpperCase()).concat(fieldName.substring(1)) : "set".concat(fieldName.toUpperCase());
        for (CtMethod method : cls.getMethods()) {
            if (!name.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LoggerFactory.getLogger(VelocityEnhancer.class);
        engine = new VelocityEngine();
        try {
            engine.setProperty("resource.loader", (Object)"class");
            engine.setProperty("class.resource.loader.description", (Object)"Classpath Loader");
            engine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            engine.setProperty("runtime.log.logsystem.class", (Object)"org.iternine.jeppetto.enhance.SLF4JLogChute");
            engine.init();
        }
        catch (Exception e) {
            logger.error("Unrecoverable error initializing Velocity.", (Throwable)e);
        }
        pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(VelocityEnhancer.class));
    }
}

