/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.enhance;

import org.iternine.jeppetto.enhance.Enhancer;

public class ChainingEnhancer<T>
extends Enhancer<T> {
    private Enhancer<T> first;
    private Enhancer<T> second;

    public ChainingEnhancer(Class<T> rawClass, Enhancer<T> first, Enhancer<T> second) {
        super(rawClass);
        this.first = first;
        this.second = second;
    }

    @Override
    protected Class<? extends T> enhanceClass(Class<T> baseClass) {
        return this.second.enhanceClass(this.first.enhanceClass(baseClass));
    }

    @Override
    public boolean needsEnhancement(Object object) {
        return this.first.needsEnhancement(object) || this.second.needsEnhancement(object);
    }

    @Override
    public Class<? extends T> getEnhancedClass() {
        return this.second.getEnhancedClass();
    }

    @Override
    public T enhance(T t) {
        return this.second.enhance(this.first.enhance(t));
    }

    @Override
    public T newInstance() {
        return this.second.newInstance();
    }
}

