/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.enhance;

import org.iternine.jeppetto.enhance.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Enhancer<T> {
    private final Class<T> baseClass;
    private Class<? extends T> enhancedClass;
    private static final Logger logger = LoggerFactory.getLogger(Enhancer.class);

    protected Enhancer(Class<T> baseClass) {
        this.validateClassIsEnhanceable(baseClass);
        this.baseClass = baseClass;
    }

    public abstract boolean needsEnhancement(Object var1);

    protected abstract Class<? extends T> enhanceClass(Class<T> var1);

    public void validateClassIsEnhanceable(Class<T> baseClass) {
        if (baseClass.isInterface()) {
            throw new IllegalArgumentException("Cannot enhance interface: " + baseClass.getSimpleName());
        }
    }

    public final Class<T> getBaseClass() {
        return this.baseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends T> getEnhancedClass() {
        if (this.enhancedClass == null) {
            Class<T> clazz = this.baseClass;
            synchronized (clazz) {
                if (this.enhancedClass == null) {
                    this.enhancedClass = this.enhanceClass(this.baseClass);
                }
            }
        }
        return this.enhancedClass;
    }

    public T newInstance() {
        try {
            return this.getEnhancedClass().newInstance();
        }
        catch (Exception e) {
            logger.error("Could not instantiate enhanced object.", (Throwable)e);
            throw ExceptionUtil.propagate(e);
        }
    }

    public T enhance(T t) {
        if (!this.needsEnhancement(t)) {
            return t;
        }
        try {
            return this.getEnhancedClass().getConstructor(this.baseClass).newInstance(t);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not enhance object %s (%s)", t, t.getClass()), e);
        }
    }
}

