/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.enhance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.CannotCompileException;
import javassist.CtClass;
import org.iternine.jeppetto.enhance.ExceptionUtil;
import org.slf4j.LoggerFactory;

public final class ClassLoadingUtil {
    private static final Lock LOCK = new ReentrantLock(false);
    private static final Method DEFINE_METHOD_NO_DOMAIN;
    private static final Method DEFINE_METHOD_WITH_DOMAIN;

    private ClassLoadingUtil() {
    }

    public static <T> Class<T> toClass(CtClass ctClass) throws CannotCompileException {
        return ClassLoadingUtil.toClass(ctClass, ClassLoadingUtil.class.getClassLoader(), null);
    }

    public static <T> Class<T> toClass(CtClass ctClass, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        try {
            byte[] byteCode = ctClass.toBytecode();
            if (domain == null) {
                Class<T> clazz = ClassLoadingUtil.bruteForceDefineClass(DEFINE_METHOD_NO_DOMAIN, loader, ctClass.getName(), byteCode, 0, byteCode.length);
                return clazz;
            }
            Class<T> clazz = ClassLoadingUtil.bruteForceDefineClass(DEFINE_METHOD_WITH_DOMAIN, loader, ctClass.getName(), byteCode, 0, byteCode.length, domain);
            return clazz;
        }
        catch (Exception e) {
            ExceptionUtil.propagateIfInstanceOf(e, CannotCompileException.class);
            ExceptionUtil.propagateIfPossible(e);
            throw new CannotCompileException((Throwable)e);
        }
        finally {
            ctClass.prune();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Class<T> bruteForceDefineClass(Method method, ClassLoader loader, Object ... args) throws InvocationTargetException, IllegalAccessException {
        LOCK.lock();
        try {
            assert (!method.isAccessible()) : "This method shouldn't be left accessible, something is wrong!";
            method.setAccessible(true);
            Class cls = (Class)method.invoke((Object)loader, args);
            method.setAccessible(false);
            Class clazz = cls;
            return clazz;
        }
        finally {
            LOCK.unlock();
        }
    }

    static {
        try {
            LoggerFactory.getLogger(ClassLoadingUtil.class).info("Entering class initializer for ClassLoadingUtil. ClassLoader=" + ClassLoadingUtil.class.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class<?> clsLoaderCls = Class.forName("java.lang.ClassLoader");
            DEFINE_METHOD_NO_DOMAIN = clsLoaderCls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            DEFINE_METHOD_WITH_DOMAIN = clsLoaderCls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize ClassLoadingUtil.");
        }
    }
}

