/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.enhance;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateHelper {
    private static AtomicInteger COUNT = new AtomicInteger(1);
    private static Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS;
    private String className;
    private String superClassName;
    private List<String> interfaceNames = new ArrayList<String>();
    private CtClass thisClass;
    private ClassPool pool;
    private static Logger logger;

    public TemplateHelper(ClassPool pool) {
        this.pool = pool;
    }

    public TemplateHelper cls(String name) {
        String newClassName = name + "$" + COUNT.getAndIncrement();
        this.thisClass = this.pool.makeClass(newClassName);
        this.className = this.thisClass.getSimpleName();
        return this;
    }

    public String clsName() {
        return this.className;
    }

    public TemplateHelper ext(CtClass superClass) throws CannotCompileException {
        this.superClassName = superClass.getName();
        this.thisClass.setSuperclass(superClass);
        return this;
    }

    public TemplateHelper impl(String interfaceName) throws NotFoundException {
        this.interfaceNames.add(interfaceName);
        this.thisClass.addInterface(this.pool.get(interfaceName));
        return this;
    }

    public String field(String code) throws CannotCompileException {
        CtField field;
        try {
            field = CtField.make((String)code, (CtClass)this.thisClass);
        }
        catch (CannotCompileException e) {
            logger.error("Unable to compile this code:\n" + code);
            throw e;
        }
        this.thisClass.addField(field);
        return code;
    }

    public String ctor(String code) throws CannotCompileException {
        CtConstructor constructor;
        try {
            constructor = CtNewConstructor.make((String)code, (CtClass)this.thisClass);
        }
        catch (CannotCompileException e) {
            logger.error("Unable to compile this code:\n" + code);
            throw e;
        }
        this.thisClass.addConstructor(constructor);
        return code;
    }

    public String method(String code) throws CannotCompileException {
        CtMethod m;
        try {
            m = CtNewMethod.make((String)code, (CtClass)this.thisClass);
        }
        catch (CannotCompileException e) {
            logger.error("Unable to compile this code:\n" + code);
            throw e;
        }
        this.thisClass.addMethod(m);
        return code;
    }

    public String asSetter(String field) {
        return String.format("set%s%s", Character.valueOf(Character.toUpperCase(field.charAt(0))), field.substring(1));
    }

    public String fieldFor(String getterName) {
        String sub;
        if (getterName.startsWith("is")) {
            sub = getterName.substring(2);
        } else if (getterName.startsWith("get")) {
            sub = getterName.substring(3);
        } else {
            throw new RuntimeException("Unexpected getter: " + getterName);
        }
        return sub.substring(0, 1).toLowerCase().concat(sub.substring(1));
    }

    public Class<?> returnTypeOf(CtMethod method) throws ClassNotFoundException, NoSuchMethodException {
        Method rawMethod = this.getRawMethod(method);
        Pair<Class<?>, Class<?>[]> genericTypePair = this.getGenericTypePair(rawMethod.getGenericReturnType());
        return genericTypePair.getFirst();
    }

    public Class<?> collectionType(CtMethod method) throws ClassNotFoundException, NoSuchMethodException {
        Method rawMethod = this.getRawMethod(method);
        Pair<Class<?>, Class<?>[]> genericTypePair = this.getGenericTypePair(rawMethod.getGenericReturnType());
        Class<?>[] returnTypeParams = genericTypePair.getSecond();
        if (returnTypeParams.length == 0) {
            return null;
        }
        return returnTypeParams[returnTypeParams.length - 1];
    }

    public String wrapperNameFor(Class<?> cls) {
        assert (cls.isPrimitive()) : "Don't call this with a non-primitive type.";
        for (Class<?> primitive : PRIMITIVE_WRAPPERS.keySet()) {
            if (!primitive.getName().equals(cls.getName())) continue;
            return PRIMITIVE_WRAPPERS.get(primitive).getName();
        }
        throw new RuntimeException("No primitive type found for " + cls);
    }

    public CtClass compile() {
        return this.thisClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ").append(this.className);
        if (this.superClassName != null) {
            sb.append(" extends ").append(this.superClassName);
        }
        if (!this.interfaceNames.isEmpty()) {
            sb.append(" implements ");
            for (int i = 0; i < this.interfaceNames.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.interfaceNames.get(i));
            }
        }
        return sb.toString();
    }

    private Pair<Class<?>, Class<?>[]> getGenericTypePair(Type type) {
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            Class[] optionalValueTypes = null;
            ParameterizedType ptype = (ParameterizedType)type;
            if (Map.class.isAssignableFrom((Class)ptype.getRawType())) {
                optionalValueTypes = new Class[]{(Class)ptype.getActualTypeArguments()[0], (Class)ptype.getActualTypeArguments()[1]};
            } else if (Iterable.class.isAssignableFrom((Class)ptype.getRawType())) {
                optionalValueTypes = new Class[]{(Class)ptype.getActualTypeArguments()[0]};
            }
            return new Pair<Class, Object>((Class)ptype.getRawType(), optionalValueTypes);
        }
        return new Pair((Class)type, new Class[0]);
    }

    private Method getRawMethod(CtMethod method) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> rawClass = Class.forName(method.getDeclaringClass().getName());
        return rawClass.getMethod(method.getName(), new Class[0]);
    }

    static {
        logger = LoggerFactory.getLogger(TemplateHelper.class);
        PRIMITIVE_WRAPPERS = new HashMap();
        PRIMITIVE_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPERS.put(Void.TYPE, Void.class);
    }

    public class Pair<E, F> {
        private E first;
        private F second;

        public Pair(E first, F second) {
            this.first = first;
            this.second = second;
        }

        public E getFirst() {
            return this.first;
        }

        public F getSecond() {
            return this.second;
        }
    }
}

