/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test;

import java.util.Collections;
import java.util.List;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.SimpleAccessControlContext;
import org.iternine.jeppetto.test.AccessControlTestDAO;
import org.iternine.jeppetto.test.RelatedObject;
import org.iternine.jeppetto.test.SettableAccessControlContextProvider;
import org.iternine.jeppetto.test.SimpleObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AccessControlTest {
    private SettableAccessControlContextProvider accessControlContextProvider;
    private static SimpleAccessControlContext accessControlContext1 = new SimpleAccessControlContext();
    private static SimpleAccessControlContext accessControlContext2;
    private static SimpleAccessControlContext accessControlContext3;
    private static SimpleAccessControlContext accessControlContext4;

    protected abstract AccessControlTestDAO getAccessControlTestDAO();

    protected abstract void reset();

    @Before
    public void before() {
        this.accessControlContextProvider = (SettableAccessControlContextProvider)this.getAccessControlTestDAO().getAccessControlContextProvider();
    }

    @After
    public void after() {
        this.reset();
        this.accessControlContextProvider = null;
    }

    @Test
    public void authorizedAccessAttempt() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getAccessControlTestDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void unauthorizedAccessAttempt() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext2);
        this.getAccessControlTestDAO().findById(simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void unauthorizedAccessAttemptWithEmptyAccessControlContext() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext4);
        this.getAccessControlTestDAO().findById(simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void unauthorizedAccessAttemptWithEmptyACLAndEmptyAccessControlContext() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.getAccessControlTestDAO().revokeAccess(simpleObject.getId(), accessControlContext1.getAccessId());
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext4);
        this.getAccessControlTestDAO().findById(simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void cantAccessCreatedObjectWithEmptyEmptyAccessControlContext() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext4);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.getAccessControlTestDAO().findById(simpleObject.getId());
    }

    @Test
    public void grantedAccessAttempt() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.getAccessControlTestDAO().grantAccess(simpleObject.getId(), accessControlContext2.getAccessId());
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext2);
        SimpleObject resultObject = (SimpleObject)this.getAccessControlTestDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        Assert.assertEquals((long)2L, (long)this.getAccessControlTestDAO().getAccessIds(resultObject.getId()).size());
    }

    @Test
    public void getList() {
        int i;
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        for (i = 0; i < 10; ++i) {
            this.getAccessControlTestDAO().save(new SimpleObject());
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext2);
        for (i = 0; i < 5; ++i) {
            this.getAccessControlTestDAO().save(new SimpleObject());
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        Iterable simpleObjectsAvailableToUser1 = this.getAccessControlTestDAO().findAll();
        String randomSimpleObjectId = null;
        int count = 0;
        for (SimpleObject simpleObject : simpleObjectsAvailableToUser1) {
            if (randomSimpleObjectId == null) {
                randomSimpleObjectId = simpleObject.getId();
            }
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext2);
        Iterable simpleObjectsAvailableToUser2 = this.getAccessControlTestDAO().findAll();
        int count2 = 0;
        for (SimpleObject simpleObject : simpleObjectsAvailableToUser2) {
            ++count2;
        }
        Assert.assertEquals((long)5L, (long)count2);
        for (SimpleObject simpleObject : simpleObjectsAvailableToUser2) {
            Assert.assertNotSame((Object)randomSimpleObjectId, (Object)simpleObject.getId());
        }
    }

    @Test
    public void allowedRoleAccessAttempt() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext3);
        SimpleObject resultObject = (SimpleObject)this.getAccessControlTestDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test
    public void verifyOrderByWorks() {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        for (int i = 0; i < 10; ++i) {
            this.getAccessControlTestDAO().save(new SimpleObject());
        }
        List<SimpleObject> orderedItems = this.getAccessControlTestDAO().findByOrderById();
        Assert.assertEquals((long)10L, (long)orderedItems.size());
        String lastId = null;
        for (SimpleObject orderedItem : orderedItems) {
            if (lastId != null) {
                Assert.assertTrue((String)("lastId is not less than thisId: " + lastId + " !< " + orderedItem.getId()), (lastId.compareTo(orderedItem.getId()) < 0 ? 1 : 0) != 0);
            }
            lastId = orderedItem.getId();
        }
    }

    @Test
    public void associationAccessAttempt() throws NoSuchItemException {
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        SimpleObject simpleObject = new SimpleObject();
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedStringValue("foo");
        simpleObject.setRelatedObjectSet(Collections.singleton(relatedObject));
        this.getAccessControlTestDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        this.getAccessControlTestDAO().save(simpleObject);
        List<SimpleObject> resultObjects = this.getAccessControlTestDAO().findByHavingRelatedObjectSetWithRelatedStringValue("foo");
        Assert.assertEquals((long)1L, (long)resultObjects.size());
    }

    @Test
    public void checkAnnotationQueryWorks() {
        int i;
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        for (i = 1; i < 10; ++i) {
            this.getAccessControlTestDAO().save(new SimpleObject(i));
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext2);
        for (i = 2; i < 10; ++i) {
            this.getAccessControlTestDAO().save(new SimpleObject(i));
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)accessControlContext1);
        Assert.assertEquals((long)3L, (long)this.getAccessControlTestDAO().getByIntValueLessThan(4).size());
        Assert.assertEquals((long)2L, (long)this.getAccessControlTestDAO().getByIntValueLessThanSpecifyingContext(4, (AccessControlContext)accessControlContext2).size());
        Assert.assertEquals((long)5L, (long)this.getAccessControlTestDAO().getByIntValueLessThanUsingAdministratorRole(4).size());
        Assert.assertEquals((long)0L, (long)this.getAccessControlTestDAO().getByIntValueLessThanUsingBogusRole(4).size());
    }

    static {
        accessControlContext1.setAccessId("001");
        accessControlContext1.setRole("User");
        accessControlContext2 = new SimpleAccessControlContext();
        accessControlContext2.setAccessId("002");
        accessControlContext2.setRole("User");
        accessControlContext3 = new SimpleAccessControlContext();
        accessControlContext3.setAccessId("003");
        accessControlContext3.setRole("Administrator");
        accessControlContext4 = new SimpleAccessControlContext();
    }
}

