/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test.accesscontrol;

import java.util.Collections;
import java.util.Map;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.SimpleAccessControlContext;
import org.iternine.jeppetto.test.SettableAccessControlContextProvider;
import org.iternine.jeppetto.test.accesscontrol.DefaultAccessObject;
import org.iternine.jeppetto.test.accesscontrol.DefaultAccessObjectDAO;
import org.iternine.jeppetto.test.accesscontrol.IdentifiableObject;
import org.iternine.jeppetto.test.accesscontrol.IdentifiedCreatableObject;
import org.iternine.jeppetto.test.accesscontrol.IdentifiedCreatableObjectDAO;
import org.iternine.jeppetto.test.accesscontrol.RoleCreatableObject;
import org.iternine.jeppetto.test.accesscontrol.RoleCreatableObjectDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AccessControlTest {
    private SettableAccessControlContextProvider accessControlContextProvider;
    private static SimpleAccessControlContext identifiedUser = new SimpleAccessControlContext();
    private static SimpleAccessControlContext userWithCreatorsRole;
    private static SimpleAccessControlContext userWithAccessorsRole;
    private static SimpleAccessControlContext administrator;
    private static SimpleAccessControlContext anotherUser;
    private static SimpleAccessControlContext anonymousUser;

    protected abstract DefaultAccessObjectDAO getDefaultAccessObjectDAO();

    protected abstract IdentifiedCreatableObjectDAO getIdentifiedCreatableObjectDAO();

    protected abstract RoleCreatableObjectDAO getRoleCreatableObjectDAO();

    protected abstract void reset();

    @Before
    public void before() {
        this.accessControlContextProvider = (SettableAccessControlContextProvider)this.getDefaultAccessObjectDAO().getAccessControlContextProvider();
    }

    @After
    public void after() {
        this.reset();
        this.accessControlContextProvider = null;
    }

    @Test
    public void createObjectsWithUserWithCreatorsRole() {
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new RoleCreatableObject(), this.getRoleCreatableObjectDAO());
    }

    @Test
    public void createObjectsWithIdentifiedUser() {
        this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        try {
            this.saveObjectWithContext((AccessControlContext)identifiedUser, new RoleCreatableObject(), this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            return;
        }
    }

    @Test
    public void createObjectsWithAnonymousUser() {
        this.saveObjectWithContext((AccessControlContext)anonymousUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        try {
            this.saveObjectWithContext((AccessControlContext)anonymousUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException ignore) {
            try {
                this.saveObjectWithContext((AccessControlContext)anonymousUser, new RoleCreatableObject(), this.getRoleCreatableObjectDAO());
                throw new RuntimeException("Expected AccessControlException");
            }
            catch (AccessControlException accessControlException) {
                return;
            }
        }
    }

    @Test
    public void unauthorizedAccessAttempts() throws AccessControlException, NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        this.getObjectWithContext((AccessControlContext)identifiedUser, id, this.getDefaultAccessObjectDAO());
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, id, this.getDefaultAccessObjectDAO());
            throw new RuntimeException("Expected NoSuchItemException");
        }
        catch (NoSuchItemException ignore) {
            try {
                this.getObjectWithContext((AccessControlContext)anonymousUser, id, this.getDefaultAccessObjectDAO());
                throw new RuntimeException("Expected NoSuchItemException");
            }
            catch (NoSuchItemException ignore2) {
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                this.getDefaultAccessObjectDAO().revokeAccess(id, identifiedUser.getAccessId());
                try {
                    this.getObjectWithContext((AccessControlContext)identifiedUser, id, this.getDefaultAccessObjectDAO());
                    throw new RuntimeException("Expected NoSuchItemException");
                }
                catch (NoSuchItemException ignore3) {
                    try {
                        this.getObjectWithContext((AccessControlContext)anonymousUser, id, this.getDefaultAccessObjectDAO());
                        throw new RuntimeException("Expected NoSuchItemException");
                    }
                    catch (NoSuchItemException noSuchItemException) {
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void grantedAccessAttempt() throws NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.Read);
        this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, id, this.getDefaultAccessObjectDAO());
        try {
            this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
            this.getDefaultAccessObjectDAO().grantAccess(id, anotherUser.getAccessId(), AccessType.Read);
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException ignore) {
            try {
                this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
                this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.ReadWrite);
                throw new RuntimeException("Expected AccessControlException");
            }
            catch (AccessControlException ignore2) {
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.ReadWrite);
                this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
                this.getDefaultAccessObjectDAO().grantAccess(id, anotherUser.getAccessId(), AccessType.Read);
                this.getObjectWithContext((AccessControlContext)anotherUser, id, this.getDefaultAccessObjectDAO());
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                Map accessTypeMap = this.getDefaultAccessObjectDAO().getGrantedAccesses(id);
                Assert.assertEquals((long)3L, (long)accessTypeMap.size());
                Assert.assertEquals((Object)AccessType.ReadWrite, accessTypeMap.get(identifiedUser.getAccessId()));
                Assert.assertEquals((Object)AccessType.ReadWrite, accessTypeMap.get(userWithCreatorsRole.getAccessId()));
                Assert.assertEquals((Object)AccessType.Read, accessTypeMap.get(anotherUser.getAccessId()));
                return;
            }
        }
    }

    @Test
    public void updateObjectWithCreatorContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        DefaultAccessObject defaultAccessObject = this.getObjectWithContext((AccessControlContext)identifiedUser, id, this.getDefaultAccessObjectDAO());
        defaultAccessObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)identifiedUser, defaultAccessObject, this.getDefaultAccessObjectDAO());
    }

    @Test
    public void updateObjectWithReadWriteContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        IdentifiedCreatableObject identifiedCreatableObject = this.getObjectWithContext((AccessControlContext)administrator, id, this.getIdentifiedCreatableObjectDAO());
        identifiedCreatableObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)identifiedUser, identifiedCreatableObject, this.getIdentifiedCreatableObjectDAO());
    }

    @Test(expected=AccessControlException.class)
    public void updateObjectWithReadContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.Read);
        DefaultAccessObject defaultAccessObject = this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, id, this.getDefaultAccessObjectDAO());
        defaultAccessObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, defaultAccessObject, this.getDefaultAccessObjectDAO());
    }

    @Test
    public void allowedRoleAccessAttempt() throws NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        this.getObjectWithContext((AccessControlContext)administrator, id, this.getIdentifiedCreatableObjectDAO());
    }

    @Test
    public void createAndGetOwnObjects() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        }
        for (i = 0; i < 5; ++i) {
            this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new DefaultAccessObject(), this.getDefaultAccessObjectDAO());
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        Iterable identifiedUserObjects = this.getDefaultAccessObjectDAO().findAll();
        String randomId = null;
        int count = 0;
        for (DefaultAccessObject defaultAccessObject : identifiedUserObjects) {
            if (randomId == null) {
                randomId = defaultAccessObject.getId();
            }
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
        Iterable userWithCreatorsRoleObjects = this.getDefaultAccessObjectDAO().findAll();
        int count2 = 0;
        for (DefaultAccessObject defaultAccessObject : userWithCreatorsRoleObjects) {
            Assert.assertNotSame((Object)randomId, (Object)defaultAccessObject.getId());
            ++count2;
        }
        Assert.assertEquals((long)5L, (long)count2);
    }

    @Test
    public void creatorWithAccessTypeNoneCantAccessObject() {
        String id = this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new RoleCreatableObject(), this.getRoleCreatableObjectDAO());
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, id, this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Creator should be able to access this object (grantedAccess of None prohibits)");
        }
        catch (NoSuchItemException noSuchItemException) {
            this.getObjectWithContext((AccessControlContext)userWithAccessorsRole, id, this.getRoleCreatableObjectDAO());
            return;
        }
    }

    private String saveObjectWithContext(AccessControlContext context, IdentifiableObject object, GenericDAO dao) {
        this.accessControlContextProvider.setCurrent(context);
        dao.save((Object)object);
        this.accessControlContextProvider.setCurrent(null);
        return object.getId();
    }

    private <T extends IdentifiableObject, ID> T getObjectWithContext(AccessControlContext context, ID id, GenericDAO<T, ID> dao) throws AccessControlException, NoSuchItemException {
        this.accessControlContextProvider.setCurrent(context);
        IdentifiableObject resultObject = (IdentifiableObject)dao.findById(id);
        Assert.assertEquals((Object)resultObject.getId(), id);
        this.accessControlContextProvider.setCurrent(null);
        return (T)resultObject;
    }

    static {
        identifiedUser.setAccessId("001");
        userWithCreatorsRole = new SimpleAccessControlContext();
        userWithCreatorsRole.setAccessId("002");
        userWithCreatorsRole.setRoles(Collections.singleton("Creators"));
        userWithAccessorsRole = new SimpleAccessControlContext();
        userWithAccessorsRole.setAccessId("002");
        userWithAccessorsRole.setRoles(Collections.singleton("Accessors"));
        administrator = new SimpleAccessControlContext();
        administrator.setAccessId("003");
        administrator.setRoles(Collections.singleton("Administrator"));
        anotherUser = new SimpleAccessControlContext();
        anotherUser.setAccessId("004");
        anotherUser.setRoles(Collections.singleton("Administrator"));
        anonymousUser = new SimpleAccessControlContext();
    }
}

