/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test;

import java.util.List;
import org.iternine.jeppetto.dao.ConditionType;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.OperationType;
import org.iternine.jeppetto.dao.ProjectionType;
import org.iternine.jeppetto.dao.SortDirection;
import org.iternine.jeppetto.dao.annotation.Association;
import org.iternine.jeppetto.dao.annotation.Condition;
import org.iternine.jeppetto.dao.annotation.DataAccessMethod;
import org.iternine.jeppetto.dao.annotation.Projection;
import org.iternine.jeppetto.dao.annotation.Sort;
import org.iternine.jeppetto.test.SimpleObject;

public interface SimpleObjectDAO
extends GenericDAO<SimpleObject, String> {
    public SimpleObject findByIntValue(int var1) throws NoSuchItemException;

    public SimpleObject findByLongValue(long var1) throws NoSuchItemException;

    public int countByIntValue(int var1);

    public int countByIntValueLessThan(int var1);

    @DataAccessMethod(conditions={@Condition(field="intValue", type=ConditionType.Equal)})
    public SimpleObject findSimpleObject(int var1) throws NoSuchItemException;

    @DataAccessMethod(conditions={@Condition(field="intValue", type=ConditionType.Within)})
    public List<SimpleObject> findSomeObjects(List<Integer> var1);

    @DataAccessMethod(associations={@Association(field="relatedObjects", conditions={@Condition(field="relatedIntValue", type=ConditionType.LessThan)})}, sorts={@Sort(field="intValue", direction=SortDirection.Descending)})
    public List<SimpleObject> findAndSortRelatedItems(int var1);

    @DataAccessMethod(associations={@Association(field="relatedObjects", conditions={@Condition(field="relatedIntValue", type=ConditionType.LessThan)})}, sorts={@Sort(field="intValue", direction=SortDirection.Descending)})
    public Iterable<SimpleObject> findAndSortRelatedItemsIterable(int var1);

    @DataAccessMethod(associations={@Association(field="relatedObjects", conditions={@Condition(field="relatedIntValue", type=ConditionType.LessThan)})}, projections={@Projection(type=ProjectionType.RowCount)})
    public int countRelatedItems(int var1);

    @DataAccessMethod(associations={@Association(field="relatedObjects", conditions={@Condition(field="relatedIntValue", type=ConditionType.LessThan)})}, sorts={@Sort(field="intValue", direction=SortDirection.Ascending)}, limitResults=true)
    public List<SimpleObject> limitRelatedItems(int var1, int var2);

    @DataAccessMethod(associations={@Association(field="relatedObjects", conditions={@Condition(field="relatedIntValue", type=ConditionType.LessThan)})}, sorts={@Sort(field="intValue", direction=SortDirection.Ascending)}, limitResults=true, skipResults=true)
    public List<SimpleObject> limitAndSkipRelatedItems(int var1, int var2, int var3);

    public List<SimpleObject> findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValueAndLimitAndSkip(int var1, int var2, int var3);

    @DataAccessMethod(conditions={@Condition(field="intValue", type=ConditionType.GreaterThan)}, projections={@Projection(type=ProjectionType.RowCount)})
    public int doAnAnnotationBasedCount(int var1);

    @DataAccessMethod(conditions={@Condition(field="intValue", type=ConditionType.GreaterThanEqual)}, projections={@Projection(type=ProjectionType.RowCount)})
    public int doAnAnnotationBasedCountGreaterThanEquals(int var1);

    @DataAccessMethod(conditions={@Condition(field="intValue", type=ConditionType.LessThanEqual)}, projections={@Projection(type=ProjectionType.RowCount)})
    public int doAnAnnotationBasedCountLessThanEquals(int var1);

    public int countByIntValueGreaterThanEqual(int var1);

    public int countByIntValueLessThanEqual(int var1);

    @DataAccessMethod(projections={@Projection(type=ProjectionType.RowCount)})
    public int countAll();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.Sum, field="intValue")})
    public int sumIntValues();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.Average, field="intValue")})
    public double averageIntValues();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.Minimum, field="intValue")})
    public int minIntValue();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.Maximum, field="intValue")})
    public int maxIntValue();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.CountDistinct, field="intValue")})
    public int countDistinctIntValue();

    @DataAccessMethod(projections={@Projection(type=ProjectionType.CountDistinct, field="intValue")})
    public int countIntValue();

    public void deleteByIntValueWithin(List<Integer> var1);

    @DataAccessMethod(operation=OperationType.Delete, conditions={@Condition(field="intValue", type=ConditionType.Within)})
    public void deleteSomeObjects(List<Integer> var1);
}

