/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.test.RelatedObject;
import org.iternine.jeppetto.test.SimpleEnum;
import org.iternine.jeppetto.test.SimpleObject;
import org.iternine.jeppetto.test.SimpleObjectDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class SimpleObjectDAOTest {
    protected abstract SimpleObjectDAO getSimpleObjectDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findById() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        this.getSimpleObjectDAO().save(simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getSimpleObjectDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void findByBogusId() throws NoSuchItemException {
        this.getSimpleObjectDAO().findById("bogusId");
    }

    @Test
    public void findByIntValue() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(20);
        this.getSimpleObjectDAO().save(simpleObject);
        SimpleObject resultObject = this.getSimpleObjectDAO().findByIntValue(20);
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test
    public void findByLongValue() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setLongValue(1409040442249560600L);
        this.getSimpleObjectDAO().save(simpleObject);
        SimpleObject resultObject = this.getSimpleObjectDAO().findByLongValue(1409040442249560600L);
        Assert.assertEquals((long)resultObject.getLongValue(), (long)simpleObject.getLongValue());
    }

    @Test
    public void findSimpleObject() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(21);
        simpleObject.setSimpleEnum(SimpleEnum.EnumValue);
        this.getSimpleObjectDAO().save(simpleObject);
        SimpleObject resultObject = this.getSimpleObjectDAO().findSimpleObject(21);
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test
    public void countSomeObjects() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countByIntValueLessThan(100));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().countByIntValueLessThan(3));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValueLessThan(2));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().countByIntValueLessThan(1));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().countByIntValue(0));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValue(1));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValue(2));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValue(3));
    }

    @Test
    public void countSomeObjectsUsingAnnotation() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCount(0));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCount(1));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCount(2));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCount(3));
    }

    @Test
    public void countSomeObjectsUsingAnnotationGreaterThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountGreaterThanEquals(0));
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountGreaterThanEquals(1));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountGreaterThanEquals(2));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountGreaterThanEquals(3));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountGreaterThanEquals(4));
    }

    @Test
    public void countSomeObjectsUsingDslStyleGreaterThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countByIntValueGreaterThanEqual(0));
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countByIntValueGreaterThanEqual(1));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().countByIntValueGreaterThanEqual(2));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValueGreaterThanEqual(3));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().countByIntValueGreaterThanEqual(4));
    }

    @Test
    public void countSomeObjectsUsingAnnotationLessThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountLessThanEquals(4));
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountLessThanEquals(3));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountLessThanEquals(2));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountLessThanEquals(1));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().doAnAnnotationBasedCountLessThanEquals(0));
    }

    @Test
    public void countSomeObjectsUsingDslStyleLessThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countByIntValueLessThanEqual(4));
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countByIntValueLessThanEqual(3));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().countByIntValueLessThanEqual(2));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countByIntValueLessThanEqual(1));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().countByIntValueLessThanEqual(0));
    }

    @Test
    public void countAll() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countAll());
    }

    @Test
    public void sumIntValues() {
        this.createData();
        Assert.assertEquals((double)6.0, (double)this.getSimpleObjectDAO().sumIntValues(), (double)0.0);
    }

    @Test
    public void averageIntValues() {
        this.createData();
        Assert.assertEquals((double)2.0, (double)this.getSimpleObjectDAO().averageIntValues(), (double)0.0);
    }

    @Test
    public void minIntValue() {
        this.createData();
        Assert.assertEquals((double)1.0, (double)this.getSimpleObjectDAO().minIntValue(), (double)0.0);
    }

    @Test
    public void maxIntValue() {
        this.createData();
        Assert.assertEquals((double)3.0, (double)this.getSimpleObjectDAO().maxIntValue(), (double)0.0);
    }

    @Test
    public void countDistinctIntValue() {
        this.createExtraData();
        Assert.assertEquals((long)5L, (long)this.getSimpleObjectDAO().countAll());
        Assert.assertEquals((long)4L, (long)this.getSimpleObjectDAO().countDistinctIntValue());
    }

    @Test
    public void findSomeObjects() {
        this.createData();
        List<SimpleObject> results = this.getSimpleObjectDAO().findSomeObjects(Arrays.asList(1, 3, 4));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((results.get(0).getIntValue() == 1 || results.get(0).getIntValue() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((results.get(0).getIntValue() != results.get(1).getIntValue() ? 1 : 0) != 0);
    }

    @Test
    public void findAndSort() {
        this.createData();
        List<SimpleObject> results = this.getSimpleObjectDAO().findAndSortRelatedItems(19);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(0).getIntValue());
        Assert.assertEquals((long)2L, (long)results.get(1).getIntValue());
    }

    @Test
    public void findAndSortReturnIterable() {
        this.createData();
        Iterable<SimpleObject> results = this.getSimpleObjectDAO().findAndSortRelatedItemsIterable(19);
        Iterator<SimpleObject> i = results.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((long)3L, (long)i.next().getIntValue());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((long)2L, (long)i.next().getIntValue());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void countRelatedItems() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getSimpleObjectDAO().countRelatedItems(21));
        Assert.assertEquals((long)2L, (long)this.getSimpleObjectDAO().countRelatedItems(20));
        Assert.assertEquals((long)1L, (long)this.getSimpleObjectDAO().countRelatedItems(15));
        Assert.assertEquals((long)0L, (long)this.getSimpleObjectDAO().countRelatedItems(10));
    }

    @Test
    public void limit() {
        this.createData();
        List<SimpleObject> results = this.getSimpleObjectDAO().limitRelatedItems(19, 1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)2L, (long)results.get(0).getIntValue());
    }

    @Test
    public void limitAndSkip() {
        this.createData();
        List<SimpleObject> results = this.getSimpleObjectDAO().limitAndSkipRelatedItems(19, 1, 1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(0).getIntValue());
    }

    @Test
    public void limitAndSkipDSL() {
        this.createData();
        List<SimpleObject> results = this.getSimpleObjectDAO().findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValueAndLimitAndSkip(19, 1, 1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(0).getIntValue());
    }

    protected void createData() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(20);
        simpleObject.addRelatedObject(relatedObject);
        this.getSimpleObjectDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(2);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(15);
        simpleObject.addRelatedObject(relatedObject);
        this.getSimpleObjectDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(3);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(10);
        simpleObject.addRelatedObject(relatedObject);
        this.getSimpleObjectDAO().save(simpleObject);
    }

    protected void createExtraData() {
        this.createData();
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(-1);
        this.getSimpleObjectDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(3);
        this.getSimpleObjectDAO().save(simpleObject);
    }
}

