/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test.accesscontrol;

import java.util.Collections;
import java.util.Map;
import org.iternine.jeppetto.dao.AccessControlContext;
import org.iternine.jeppetto.dao.AccessControlException;
import org.iternine.jeppetto.dao.AccessType;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.SettableAccessControlContextProvider;
import org.iternine.jeppetto.dao.SimpleAccessControlContext;
import org.iternine.jeppetto.test.accesscontrol.DefaultAccessObject;
import org.iternine.jeppetto.test.accesscontrol.DefaultAccessObjectDAO;
import org.iternine.jeppetto.test.accesscontrol.IdentifiableObject;
import org.iternine.jeppetto.test.accesscontrol.IdentifiedCreatableObject;
import org.iternine.jeppetto.test.accesscontrol.IdentifiedCreatableObjectDAO;
import org.iternine.jeppetto.test.accesscontrol.RoleCreatableObject;
import org.iternine.jeppetto.test.accesscontrol.RoleCreatableObjectDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AccessControlTest {
    private SettableAccessControlContextProvider accessControlContextProvider;
    private static SimpleAccessControlContext identifiedUser = new SimpleAccessControlContext("001");
    private static SimpleAccessControlContext userWithCreatorsRole = new SimpleAccessControlContext("002", Collections.singleton("Creators"));
    private static SimpleAccessControlContext userWithAccessorsRole = new SimpleAccessControlContext("003", Collections.singleton("Accessors"));
    private static SimpleAccessControlContext administrator = new SimpleAccessControlContext("004", Collections.singleton("Administrator"));
    private static SimpleAccessControlContext anotherUser = new SimpleAccessControlContext("005", Collections.singleton("Administrator"));
    private static SimpleAccessControlContext anonymousUser = new SimpleAccessControlContext();

    protected abstract DefaultAccessObjectDAO getDefaultAccessObjectDAO();

    protected abstract IdentifiedCreatableObjectDAO getIdentifiedCreatableObjectDAO();

    protected abstract RoleCreatableObjectDAO getRoleCreatableObjectDAO();

    protected abstract void reset();

    @Before
    public void before() {
        this.accessControlContextProvider = (SettableAccessControlContextProvider)this.getDefaultAccessObjectDAO().getAccessControlContextProvider();
    }

    @After
    public void after() {
        this.reset();
        this.accessControlContextProvider = null;
    }

    @Test
    public void createObjectsWithUserWithCreatorsRole() {
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new RoleCreatableObject(), (GenericDAO)this.getRoleCreatableObjectDAO());
    }

    @Test
    public void createObjectsWithIdentifiedUser() {
        this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        try {
            this.saveObjectWithContext((AccessControlContext)identifiedUser, new RoleCreatableObject(), (GenericDAO)this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            return;
        }
    }

    @Test
    public void createObjectsWithAnonymousUser() {
        this.saveObjectWithContext((AccessControlContext)anonymousUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        try {
            this.saveObjectWithContext((AccessControlContext)anonymousUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException ignore) {
            try {
                this.saveObjectWithContext((AccessControlContext)anonymousUser, new RoleCreatableObject(), (GenericDAO)this.getRoleCreatableObjectDAO());
                throw new RuntimeException("Expected AccessControlException");
            }
            catch (AccessControlException accessControlException) {
                return;
            }
        }
    }

    @Test
    public void unauthorizedAccessAttempts() throws AccessControlException, NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        this.getObjectWithContext((AccessControlContext)identifiedUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
            throw new RuntimeException("Expected NoSuchItemException");
        }
        catch (NoSuchItemException ignore) {
            try {
                this.getObjectWithContext((AccessControlContext)anonymousUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
                throw new RuntimeException("Expected NoSuchItemException");
            }
            catch (NoSuchItemException ignore2) {
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                this.getDefaultAccessObjectDAO().revokeAccess(id, identifiedUser.getAccessId());
                try {
                    this.getObjectWithContext((AccessControlContext)identifiedUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
                    throw new RuntimeException("Expected NoSuchItemException");
                }
                catch (NoSuchItemException ignore3) {
                    try {
                        this.getObjectWithContext((AccessControlContext)anonymousUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
                        throw new RuntimeException("Expected NoSuchItemException");
                    }
                    catch (NoSuchItemException noSuchItemException) {
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void grantedAccessAttempt() throws NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.Read);
        this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
        try {
            this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
            this.getDefaultAccessObjectDAO().grantAccess(id, anotherUser.getAccessId(), AccessType.Read);
            throw new RuntimeException("Expected AccessControlException");
        }
        catch (AccessControlException ignore) {
            try {
                this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
                this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.ReadWrite);
                throw new RuntimeException("Expected AccessControlException");
            }
            catch (AccessControlException ignore2) {
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.ReadWrite);
                this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
                this.getDefaultAccessObjectDAO().grantAccess(id, anotherUser.getAccessId(), AccessType.Read);
                this.getObjectWithContext((AccessControlContext)anotherUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
                this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
                Map accessTypeMap = this.getDefaultAccessObjectDAO().getGrantedAccesses(id);
                Assert.assertEquals((long)3L, (long)accessTypeMap.size());
                Assert.assertEquals((Object)AccessType.ReadWrite, accessTypeMap.get(identifiedUser.getAccessId()));
                Assert.assertEquals((Object)AccessType.ReadWrite, accessTypeMap.get(userWithCreatorsRole.getAccessId()));
                Assert.assertEquals((Object)AccessType.Read, accessTypeMap.get(anotherUser.getAccessId()));
                return;
            }
        }
    }

    @Test
    public void updateObjectWithCreatorContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        DefaultAccessObject defaultAccessObject = (DefaultAccessObject)this.getObjectWithContext((AccessControlContext)identifiedUser, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
        defaultAccessObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)identifiedUser, defaultAccessObject, (GenericDAO)this.getDefaultAccessObjectDAO());
    }

    @Test
    public void updateObjectWithReadWriteContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        IdentifiedCreatableObject identifiedCreatableObject = this.getObjectWithContext((AccessControlContext)administrator, id, this.getIdentifiedCreatableObjectDAO());
        identifiedCreatableObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)identifiedUser, identifiedCreatableObject, this.getIdentifiedCreatableObjectDAO());
    }

    @Test(expected=AccessControlException.class)
    public void updateObjectWithReadContext() {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        this.getDefaultAccessObjectDAO().grantAccess(id, userWithCreatorsRole.getAccessId(), AccessType.Read);
        DefaultAccessObject defaultAccessObject = (DefaultAccessObject)this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)id, (GenericDAO)this.getDefaultAccessObjectDAO());
        defaultAccessObject.setIntValue(5);
        this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, defaultAccessObject, (GenericDAO)this.getDefaultAccessObjectDAO());
    }

    @Test
    public void allowedRoleAccessAttempt() throws NoSuchItemException {
        String id = this.saveObjectWithContext((AccessControlContext)identifiedUser, new IdentifiedCreatableObject(), this.getIdentifiedCreatableObjectDAO());
        this.getObjectWithContext((AccessControlContext)administrator, id, this.getIdentifiedCreatableObjectDAO());
    }

    @Test
    public void createAndGetOwnObjects() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.saveObjectWithContext((AccessControlContext)identifiedUser, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        }
        for (i = 0; i < 5; ++i) {
            this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        }
        this.accessControlContextProvider.setCurrent((AccessControlContext)identifiedUser);
        Iterable identifiedUserObjects = this.getDefaultAccessObjectDAO().findAll();
        String randomId = null;
        int count = 0;
        for (DefaultAccessObject defaultAccessObject : identifiedUserObjects) {
            if (randomId == null) {
                randomId = defaultAccessObject.getId();
            }
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        this.accessControlContextProvider.setCurrent((AccessControlContext)userWithCreatorsRole);
        Iterable userWithCreatorsRoleObjects = this.getDefaultAccessObjectDAO().findAll();
        int count2 = 0;
        for (DefaultAccessObject defaultAccessObject : userWithCreatorsRoleObjects) {
            Assert.assertNotSame((Object)randomId, (Object)defaultAccessObject.getId());
            ++count2;
        }
        Assert.assertEquals((long)5L, (long)count2);
    }

    @Test
    public void creatorWithAccessTypeNoneCantAccessObject() {
        String id = this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new RoleCreatableObject(), (GenericDAO)this.getRoleCreatableObjectDAO());
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)id, (GenericDAO)this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Creator should not be able to access this object (grantedAccess of None prohibits)");
        }
        catch (NoSuchItemException noSuchItemException) {
            this.getObjectWithContext((AccessControlContext)userWithAccessorsRole, (Object)id, (GenericDAO)this.getRoleCreatableObjectDAO());
            return;
        }
    }

    @Test
    public void accessObjectUsingAsQueries() {
        String id = this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new RoleCreatableObject(), (GenericDAO)this.getRoleCreatableObjectDAO());
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)id, (GenericDAO)this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Creator should not be able to access this object (grantedAccess of None prohibits)");
        }
        catch (NoSuchItemException ignore) {
            RoleCreatableObject roleCreatableObject = this.getRoleCreatableObjectDAO().findByIdAs(id, (AccessControlContext)userWithAccessorsRole);
            Assert.assertEquals((Object)id, (Object)roleCreatableObject.getId());
            try {
                this.getRoleCreatableObjectDAO().findByIdAs(id, (AccessControlContext)anotherUser);
                throw new RuntimeException("User should not be able to access this object");
            }
            catch (NoSuchItemException noSuchItemException) {
                return;
            }
        }
    }

    @Test
    public void saveAndUpdateObjectWithExplicitAccessControlContext() {
        RoleCreatableObject roleCreatableObject1 = new RoleCreatableObject();
        this.getRoleCreatableObjectDAO().save(roleCreatableObject1, (AccessControlContext)userWithCreatorsRole);
        RoleCreatableObject roleCreatableObject2 = this.getRoleCreatableObjectDAO().findByIdAs(roleCreatableObject1.getId(), (AccessControlContext)userWithAccessorsRole);
        try {
            this.getRoleCreatableObjectDAO().save(roleCreatableObject2, (AccessControlContext)userWithCreatorsRole);
            throw new RuntimeException("Creator can only create, not update");
        }
        catch (AccessControlException accessControlException) {
            this.getRoleCreatableObjectDAO().save(roleCreatableObject2, (AccessControlContext)userWithAccessorsRole);
            return;
        }
    }

    @Test
    public void grantObjectAccessWithExplicitAccessControlContext() {
        RoleCreatableObject roleCreatableObject1 = new RoleCreatableObject();
        this.getRoleCreatableObjectDAO().save(roleCreatableObject1, (AccessControlContext)userWithCreatorsRole);
        try {
            this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)roleCreatableObject1.getId(), (GenericDAO)this.getRoleCreatableObjectDAO());
            throw new RuntimeException("Creator should not be able to access this object (grantedAccess of None prohibits)");
        }
        catch (NoSuchItemException ignore) {
            try {
                this.getRoleCreatableObjectDAO().grantAccess(roleCreatableObject1.getId(), userWithCreatorsRole.getAccessId(), AccessType.ReadWrite, (AccessControlContext)userWithCreatorsRole);
                throw new RuntimeException("Creator can't grant himself access");
            }
            catch (NoSuchItemException noSuchItemException) {
                this.getRoleCreatableObjectDAO().grantAccess(roleCreatableObject1.getId(), userWithCreatorsRole.getAccessId(), AccessType.ReadWrite, (AccessControlContext)userWithAccessorsRole);
                this.getObjectWithContext((AccessControlContext)userWithCreatorsRole, (Object)roleCreatableObject1.getId(), (GenericDAO)this.getRoleCreatableObjectDAO());
                return;
            }
        }
    }

    @Test
    public void verifyGrantedAccessesContainExpectedValues() {
        String id = this.saveObjectWithContext((AccessControlContext)userWithCreatorsRole, new DefaultAccessObject(), (GenericDAO)this.getDefaultAccessObjectDAO());
        Map grantedAccesses = this.getDefaultAccessObjectDAO().getGrantedAccesses(id, (AccessControlContext)userWithCreatorsRole);
        Assert.assertEquals((long)1L, (long)grantedAccesses.size());
        Assert.assertEquals((Object)userWithCreatorsRole.getAccessId(), grantedAccesses.keySet().iterator().next());
        Assert.assertEquals((Object)AccessType.ReadWrite, grantedAccesses.values().iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveObjectWithContext(AccessControlContext context, IdentifiableObject object, GenericDAO dao) {
        this.accessControlContextProvider.setCurrent(context);
        try {
            dao.save((Object)object);
            String string = object.getId();
            return string;
        }
        finally {
            this.accessControlContextProvider.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IdentifiableObject, ID> T getObjectWithContext(AccessControlContext context, ID id, GenericDAO<T, ID> dao) throws AccessControlException, NoSuchItemException {
        this.accessControlContextProvider.setCurrent(context);
        try {
            IdentifiableObject resultObject = (IdentifiableObject)dao.findById(id);
            Assert.assertEquals((Object)resultObject.getId(), id);
            IdentifiableObject identifiableObject = resultObject;
            return (T)identifiableObject;
        }
        finally {
            this.accessControlContextProvider.setCurrent(null);
        }
    }
}

