/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.iternine.jeppetto.dao.ReferenceSet;
import org.iternine.jeppetto.test.RelatedObject;
import org.iternine.jeppetto.test.SimpleEnum;
import org.iternine.jeppetto.test.SimpleObject;
import org.iternine.jeppetto.test.SimpleObjectReferencesDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class SimpleObjectReferencesDAOTest {
    protected abstract SimpleObjectReferencesDAO getSimpleObjectReferencesDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void updateSimpleFields() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.setLongValue(1L);
        simpleObject.setSimpleEnum(SimpleEnum.EnumValue);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.setLongValue(Long.MAX_VALUE);
        updateObject.setAnotherIntValue(999);
        updateObject.setSimpleEnum(null);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getAnotherIntValue());
        Assert.assertEquals(null, (Object)((Object)resultSimpleObject.getSimpleEnum()));
    }

    @Test
    public void updateSimpleFieldsInMultipleEntities() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(123);
        simpleObject1.setLongValue(1L);
        this.getSimpleObjectReferencesDAO().save(simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(234);
        simpleObject2.setLongValue(2L);
        this.getSimpleObjectReferencesDAO().save(simpleObject2);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject1.getId(), simpleObject2.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.setLongValue(Long.MAX_VALUE);
        updateObject.setAnotherIntValue(999);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject1 = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject1.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject1.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject1.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject1.getAnotherIntValue());
        SimpleObject resultSimpleObject2 = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject2.getId());
        Assert.assertEquals((long)234L, (long)resultSimpleObject2.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject2.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject2.getAnotherIntValue());
    }

    @Test
    public void addNestedObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        updateObject.setRelatedObject(relatedObject);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject.getIntValue());
        Assert.assertNotNull((Object)resultSimpleObject.getRelatedObject());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObject().getRelatedIntValue());
    }

    @Test
    public void updateNestedObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        simpleObject.setRelatedObject(relatedObject);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.setIntValue(456);
        RelatedObject relatedUpdateObject = updateObject.getRelatedObject();
        relatedUpdateObject.setRelatedIntValue(999);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getIntValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getRelatedObject().getRelatedIntValue());
    }

    @Test
    public void addNewList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        updateObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void addToExistingList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        List<RelatedObject> relatedObjectUpdate = updateObject.getRelatedObjects();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        relatedObjectUpdate.add(relatedObject2);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)2L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(1).getRelatedIntValue());
    }

    @Test
    public void setAtIndex() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjects().set(3, relatedObject2);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)4L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
        Assert.assertNull((Object)resultSimpleObject.getRelatedObjects().get(1));
        Assert.assertNull((Object)resultSimpleObject.getRelatedObjects().get(2));
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(3).getRelatedIntValue());
    }

    @Test
    public void removeFromExistingList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject1 = new RelatedObject();
        relatedObject1.setRelatedIntValue(456);
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject1);
        relatedObjects.add(relatedObject2);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        List<RelatedObject> relatedObjectUpdate = updateObject.getRelatedObjects();
        relatedObjectUpdate.remove(relatedObject1);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void clearList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.getRelatedObjects().clear();
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)0L, (long)resultSimpleObject.getRelatedObjects().size());
    }

    @Test
    public void clearAndAddToList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.getRelatedObjects().clear();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjects().add(relatedObject2);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void clearMap() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        HashMap<String, RelatedObject> relatedObjectMap = new HashMap<String, RelatedObject>();
        relatedObjectMap.put("one", relatedObject);
        simpleObject.setRelatedObjectMap(relatedObjectMap);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.getRelatedObjectMap().clear();
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjectMap());
        Assert.assertEquals((long)0L, (long)resultSimpleObject.getRelatedObjectMap().size());
    }

    @Test
    public void clearAndAddToMap() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        HashMap<String, RelatedObject> relatedObjectMap = new HashMap<String, RelatedObject>();
        relatedObjectMap.put("one", relatedObject);
        simpleObject.setRelatedObjectMap(relatedObjectMap);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.getRelatedObjectMap().clear();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjectMap().put("two", relatedObject2);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjectMap());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjectMap().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjectMap().get("two").getRelatedIntValue());
    }

    @Test
    public void addStringsToList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.addToStringList("duck");
        simpleObject.addToStringList("bunny");
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        List<String> updateList = updateObject.getStringList();
        updateList.add("bunny");
        updateList.add("cow");
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getStringList());
        Assert.assertEquals((long)4L, (long)resultSimpleObject.getStringList().size());
        Assert.assertEquals((Object)"duck", (Object)resultSimpleObject.getStringList().get(0));
        Assert.assertEquals((Object)"bunny", (Object)resultSimpleObject.getStringList().get(1));
        Assert.assertEquals((Object)"bunny", (Object)resultSimpleObject.getStringList().get(2));
        Assert.assertEquals((Object)"cow", (Object)resultSimpleObject.getStringList().get(3));
    }

    @Test
    public void addStringsToSet() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.addToStringSet("duck");
        simpleObject.addToStringSet("bunny");
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        ReferenceSet referenceSet = this.getSimpleObjectReferencesDAO().referenceByIds(new String[]{simpleObject.getId()});
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        Set<String> updateSet = updateObject.getStringSet();
        updateSet.add("bunny");
        updateSet.add("cow");
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getStringSet());
        Assert.assertEquals((long)3L, (long)resultSimpleObject.getStringSet().size());
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("duck"));
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("bunny"));
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("cow"));
    }

    @Test
    public void referenceByOtherField() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(123);
        simpleObject1.setAnotherIntValue(-1);
        this.getSimpleObjectReferencesDAO().save(simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(234);
        simpleObject2.setAnotherIntValue(-1);
        this.getSimpleObjectReferencesDAO().save(simpleObject2);
        ReferenceSet<SimpleObject> referenceSet = this.getSimpleObjectReferencesDAO().referenceByAnotherIntValue(-1);
        SimpleObject updateObject = (SimpleObject)referenceSet.getUpdateObject();
        updateObject.setAnotherIntValue(42);
        this.getSimpleObjectReferencesDAO().updateReferences(referenceSet, updateObject);
        Iterable results = this.getSimpleObjectReferencesDAO().findAll();
        int resultCount = 0;
        for (SimpleObject result : results) {
            Assert.assertEquals((long)42L, (long)result.getAnotherIntValue());
            Assert.assertTrue((result.getIntValue() == 123 || result.getIntValue() == 234 ? 1 : 0) != 0);
            ++resultCount;
        }
        Assert.assertEquals((long)2L, (long)resultCount);
    }
}

