/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.test;

import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.test.RelatedObject;
import org.iternine.jeppetto.test.SimpleObject;
import org.iternine.jeppetto.test.SimpleObjectDAO;
import org.iternine.jeppetto.test.SummarySimpleObject;
import org.iternine.jeppetto.test.SummarySimpleObjectDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class SummarySimpleObjectDAOTest {
    protected abstract SimpleObjectDAO getSimpleObjectDAO();

    protected abstract SummarySimpleObjectDAO getSummarySimpleObjectDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findById() throws NoSuchItemException {
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(20);
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setRelatedObject(relatedObject);
        simpleObject.addRelatedObject(relatedObject);
        this.getSimpleObjectDAO().save(simpleObject);
        SummarySimpleObject summarySimpleObject = (SummarySimpleObject)this.getSummarySimpleObjectDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)simpleObject.getId(), (Object)summarySimpleObject.getId());
        Assert.assertEquals((long)simpleObject.getRelatedObject().getRelatedIntValue(), (long)summarySimpleObject.getRelatedObject().getRelatedIntValue());
        Assert.assertEquals((long)1L, (long)summarySimpleObject.getRelatedObjects().size());
    }

    @Test
    public void updateSummaryObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getSimpleObjectDAO().save(simpleObject);
        SummarySimpleObject summarySimpleObject = (SummarySimpleObject)this.getSummarySimpleObjectDAO().findById(simpleObject.getId());
        summarySimpleObject.setIntValue(999);
        this.getSummarySimpleObjectDAO().save(summarySimpleObject);
        SummarySimpleObject resultSummarySimpleObject = (SummarySimpleObject)this.getSummarySimpleObjectDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)999L, (long)resultSummarySimpleObject.getIntValue());
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getIntValue());
    }
}

