/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.test.RelatedObject;
import org.iternine.jeppetto.dao.test.SimpleObject;
import org.iternine.jeppetto.dao.test.core.DynamicDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class DynamicDAOTest {
    protected abstract DynamicDAO getDynamicDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findByIntValue() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(20);
        this.getDynamicDAO().save(simpleObject);
        SimpleObject resultObject = this.getDynamicDAO().findByIntValue(20);
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test
    public void findByLongValue() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setLongValue(1409040442249560600L);
        this.getDynamicDAO().save(simpleObject);
        SimpleObject resultObject = this.getDynamicDAO().findByLongValue(1409040442249560600L);
        Assert.assertEquals((long)resultObject.getLongValue(), (long)simpleObject.getLongValue());
    }

    @Test
    public void findByTwoValues() {
        SimpleObject newOne = new SimpleObject();
        newOne.setIntValue(1);
        newOne.setAnotherIntValue(20);
        this.getDynamicDAO().save(newOne);
        List<SimpleObject> result = this.getDynamicDAO().findByIntValueAndAnotherIntValueGreaterThan(1, 0);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)newOne.getId(), (Object)result.get(0).getId());
    }

    @Test
    public void findByRelatedValue() {
        RelatedObject relatedObject1 = new RelatedObject();
        relatedObject1.setRelatedIntValue(20);
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(1);
        simpleObject1.setRelatedObject(relatedObject1);
        this.getDynamicDAO().save(simpleObject1);
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(30);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject1.setIntValue(2);
        simpleObject2.setRelatedObject(relatedObject2);
        this.getDynamicDAO().save(simpleObject2);
        SimpleObject result = this.getDynamicDAO().findByHavingRelatedObjectWithRelatedIntValue(20);
        Assert.assertEquals((long)1L, (long)result.getIntValue());
        Assert.assertEquals((long)20L, (long)result.getRelatedObject().getRelatedIntValue());
    }

    @Test
    public void verifyNullReturnWhenMethodDoesNotDeclareException() {
        SimpleObject result = this.getDynamicDAO().findByIntValue(1);
        Assert.assertNull((Object)result);
    }

    @Test(expected=NoSuchItemException.class)
    public void verifyExceptionWhenMethodDeclaresException() throws NoSuchItemException {
        this.getDynamicDAO().findByAnotherIntValue(1);
    }

    @Test
    public void verifySort() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        this.getDynamicDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(2);
        this.getDynamicDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(3);
        this.getDynamicDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(4);
        this.getDynamicDAO().save(simpleObject);
        List<SimpleObject> result = this.getDynamicDAO().findByOrderByIntValueDesc();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)4L, (long)result.get(0).getIntValue());
        Assert.assertEquals((long)3L, (long)result.get(1).getIntValue());
        Assert.assertEquals((long)2L, (long)result.get(2).getIntValue());
        Assert.assertEquals((long)1L, (long)result.get(3).getIntValue());
    }

    @Test
    public void getSet() {
        SimpleObject newOne = new SimpleObject();
        newOne.setIntValue(1);
        this.getDynamicDAO().save(newOne);
        Set<SimpleObject> result = this.getDynamicDAO().findByIntValueGreaterThan(0);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void findSomeObjects() {
        this.createData();
        List<SimpleObject> results = this.getDynamicDAO().findByIntValueWithin(Arrays.asList(1, 3, 4));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((results.get(0).getIntValue() == 1 || results.get(0).getIntValue() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((results.get(0).getIntValue() != results.get(1).getIntValue() ? 1 : 0) != 0);
    }

    @Test
    public void findAndSort() {
        this.createData();
        List<SimpleObject> results = this.getDynamicDAO().findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValueDesc(19);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(0).getIntValue());
        Assert.assertEquals((long)2L, (long)results.get(1).getIntValue());
    }

    @Test
    public void findAndSortReturnIterable() {
        this.createData();
        Iterable<SimpleObject> results = this.getDynamicDAO().findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValue(19);
        Iterator<SimpleObject> i = results.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((long)2L, (long)i.next().getIntValue());
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertEquals((long)3L, (long)i.next().getIntValue());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void limit() {
        this.createData();
        List<SimpleObject> results = this.getDynamicDAO().findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValueAndLimit(19, 1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)2L, (long)results.get(0).getIntValue());
    }

    @Test
    public void limitAndSkip() {
        this.createData();
        List<SimpleObject> results = this.getDynamicDAO().findByHavingRelatedObjectsWithRelatedIntValueLessThanOrderByIntValueAndLimitAndSkip(19, 1, 1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(0).getIntValue());
    }

    @Test
    public void saveMultipleThenDeleteSome() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1234);
        this.getDynamicDAO().save(simpleObject);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(2345);
        this.getDynamicDAO().save(simpleObject2);
        SimpleObject simpleObject3 = new SimpleObject();
        simpleObject2.setIntValue(3456);
        this.getDynamicDAO().save(simpleObject3);
        Iterable results = this.getDynamicDAO().findAll();
        int resultCount = 0;
        for (SimpleObject ignore : results) {
            ++resultCount;
        }
        Assert.assertTrue((resultCount == 3 ? 1 : 0) != 0);
        this.getDynamicDAO().deleteByIntValueWithin(Arrays.asList(1234, 2345));
        Iterable results2 = this.getDynamicDAO().findAll();
        int resultCount2 = 0;
        for (SimpleObject ignore : results2) {
            ++resultCount2;
        }
        Assert.assertTrue((resultCount2 == 1 ? 1 : 0) != 0);
    }

    protected void createData() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(20);
        simpleObject.addRelatedObject(relatedObject);
        this.getDynamicDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(2);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(15);
        simpleObject.addRelatedObject(relatedObject);
        this.getDynamicDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(3);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(10);
        simpleObject.addRelatedObject(relatedObject);
        this.getDynamicDAO().save(simpleObject);
    }
}

