/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.iternine.jeppetto.dao.GenericDAO;
import org.iternine.jeppetto.dao.JeppettoException;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.test.RelatedObject;
import org.iternine.jeppetto.dao.test.SimpleEnum;
import org.iternine.jeppetto.dao.test.SimpleObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class GenericDAOTest {
    protected abstract GenericDAO<SimpleObject, String> getGenericDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findById() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
    }

    @Test(expected=NoSuchItemException.class)
    public void findByBogusId() throws NoSuchItemException {
        this.getGenericDAO().findById((Object)"bogusId");
    }

    @Test
    public void saveAndFindWithBasicFields() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(5);
        simpleObject.setLongValue(100L);
        simpleObject.setSimpleEnum(SimpleEnum.EnumValue);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        Assert.assertEquals((long)5L, (long)resultObject.getIntValue());
        Assert.assertEquals((long)100L, (long)resultObject.getLongValue());
        Assert.assertEquals((Object)((Object)SimpleEnum.EnumValue), (Object)((Object)resultObject.getSimpleEnum()));
    }

    @Test
    public void saveAndUpdateBasicFields() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(5);
        simpleObject.setLongValue(100L);
        simpleObject.setSimpleEnum(SimpleEnum.EnumValue);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        resultObject.setIntValue(10);
        this.getGenericDAO().save((Object)resultObject);
        resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        Assert.assertEquals((long)10L, (long)resultObject.getIntValue());
        Assert.assertEquals((long)100L, (long)resultObject.getLongValue());
        Assert.assertEquals((Object)((Object)SimpleEnum.EnumValue), (Object)((Object)resultObject.getSimpleEnum()));
    }

    @Test
    public void saveAndFindWithStringList() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setStringList(new ArrayList<String>());
        simpleObject.getStringList().add("foo");
        simpleObject.getStringList().add("bar");
        simpleObject.getStringList().add("bar");
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertNotNull(resultObject.getStringList());
        Assert.assertEquals((long)3L, (long)resultObject.getStringList().size());
        Assert.assertEquals((Object)"foo", (Object)resultObject.getStringList().get(0));
        Assert.assertEquals((Object)"bar", (Object)resultObject.getStringList().get(1));
        Assert.assertEquals((Object)"bar", (Object)resultObject.getStringList().get(2));
    }

    @Test
    public void saveAndFindWithStringSet() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setStringSet(new HashSet<String>());
        simpleObject.getStringSet().add("foo");
        simpleObject.getStringSet().add("bar");
        simpleObject.getStringSet().add("bar");
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertNotNull(resultObject.getStringSet());
        Assert.assertEquals((long)2L, (long)resultObject.getStringSet().size());
        Assert.assertTrue((boolean)resultObject.getStringSet().contains("foo"));
        Assert.assertTrue((boolean)resultObject.getStringSet().contains("bar"));
    }

    @Test
    public void saveAndFindWithStringMap() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setStringMap(new HashMap<String, String>());
        simpleObject.getStringMap().put("foo", "bar");
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertNotNull(resultObject.getStringMap());
        Assert.assertEquals((Object)"bar", (Object)resultObject.getStringMap().get("foo"));
    }

    @Test
    public void saveAndFindComplexObject() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1234);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(5678);
        simpleObject.setRelatedObject(relatedObject);
        simpleObject.addRelatedObject(relatedObject);
        simpleObject.addRelatedObject("foo", relatedObject);
        simpleObject.addRelatedObject("bar", relatedObject);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        RelatedObject[] objects = resultObject.getRelatedObjects().toArray(new RelatedObject[1]);
        Assert.assertEquals((long)relatedObject.getRelatedIntValue(), (long)objects[0].getRelatedIntValue());
        Assert.assertEquals((long)relatedObject.getRelatedIntValue(), (long)resultObject.getRelatedObject().getRelatedIntValue());
        Assert.assertTrue((boolean)simpleObject.getRelatedObjectMap().containsKey("foo"));
        Assert.assertTrue((boolean)simpleObject.getRelatedObjectMap().containsKey("bar"));
        Assert.assertEquals((long)simpleObject.getRelatedObjectMap().get("foo").getRelatedIntValue(), (long)simpleObject.getRelatedObjectMap().get("bar").getRelatedIntValue());
    }

    @Test
    public void saveAndUpdateComplexObject() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1234);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(5678);
        simpleObject.setRelatedObject(relatedObject);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        resultObject.getRelatedObject().setRelatedIntValue(1111);
        this.getGenericDAO().save((Object)resultObject);
        resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        Assert.assertEquals((long)1111L, (long)resultObject.getRelatedObject().getRelatedIntValue());
    }

    @Test(expected=NoSuchItemException.class)
    public void saveAndDelete() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1234);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        this.getGenericDAO().delete((Object)simpleObject);
        this.getGenericDAO().findById((Object)simpleObject.getId());
    }

    @Test
    public void saveMultipleAndFindAll() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1234);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(5678);
        this.getGenericDAO().save((Object)simpleObject2);
        Iterable results = this.getGenericDAO().findAll();
        int resultCount = 0;
        for (SimpleObject ignore : results) {
            ++resultCount;
        }
        Assert.assertTrue((resultCount == 2 ? 1 : 0) != 0);
    }

    @Test
    public void transientValuesAreNotPersisted() throws NoSuchItemException {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(5);
        simpleObject.setTransientValue(10);
        this.getGenericDAO().save((Object)simpleObject);
        SimpleObject resultObject = (SimpleObject)this.getGenericDAO().findById((Object)simpleObject.getId());
        Assert.assertEquals((Object)resultObject.getId(), (Object)simpleObject.getId());
        Assert.assertEquals((long)5L, (long)resultObject.getIntValue());
        Assert.assertEquals((long)0L, (long)resultObject.getTransientValue());
    }

    @Test(expected=JeppettoException.class)
    public void idReuseShouldFail() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setId("a");
        simpleObject1.setIntValue(-1);
        this.getGenericDAO().save((Object)simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setId("a");
        simpleObject2.setIntValue(3);
        this.getGenericDAO().save((Object)simpleObject2);
    }

    @Test(expected=JeppettoException.class)
    public void uniqueConstraintCausesException() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(123);
        this.getGenericDAO().save((Object)simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(123);
        this.getGenericDAO().save((Object)simpleObject2);
    }
}

