/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.examples.forum;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.iternine.jeppetto.dao.test.examples.forum.Forum;
import org.iternine.jeppetto.dao.test.examples.forum.ForumDAO;
import org.iternine.jeppetto.dao.test.examples.forum.Reply;
import org.iternine.jeppetto.dao.test.examples.forum.ReplyDAO;
import org.iternine.jeppetto.dao.test.examples.forum.Thread;
import org.iternine.jeppetto.dao.test.examples.forum.ThreadDAO;
import org.junit.After;
import org.junit.Test;

public abstract class ForumTest {
    protected static final String DYNAMODB_FORUM = "Amazon DynamoDB";
    protected static final String DYNAMODB_THREAD_1 = "DynamoDB Thread 1";
    protected static final String DYNAMODB_THREAD_2 = "DynamoDB Thread 2";
    protected static final String S3_FORUM = "Amazon S3";
    protected static final String S3_THREAD_1 = "S3 Thread 1";
    protected static final String USER_A = "User A";
    protected static final String USER_B = "User B";
    protected static final Date oneDayAgo = new Date(new Date().getTime() - 86400000L);
    protected static final Date sevenDaysAgo = new Date(new Date().getTime() - 604800000L);
    protected static final Date fourteenDaysAgo = new Date(new Date().getTime() - 1209600000L);
    protected static final Date fifteenDaysAgo = new Date(new Date().getTime() - 1296000000L);
    protected static final Date twentyOneDaysAgo = new Date(new Date().getTime() - 1814400000L);

    protected abstract ForumDAO getForumDAO();

    protected abstract ThreadDAO getThreadDAO();

    protected abstract ReplyDAO getReplyDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findRepliesInLast15Days() {
        this.createData();
        List<Reply> result = this.getReplyDAO().findByIdAndReplyDateGreaterThan("Amazon DynamoDB#DynamoDB Thread 1", fifteenDaysAgo);
        Assert.assertNotNull(result);
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)USER_B, (String)result.get(0).getPostedBy());
    }

    @Test
    public void findRepliesPostedWithinTimePeriod() {
        this.createData();
        List<Reply> result = this.getReplyDAO().findByIdAndReplyDateBetween("Amazon DynamoDB#DynamoDB Thread 1", fifteenDaysAgo, sevenDaysAgo);
        Assert.assertNotNull(result);
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)USER_B, (String)result.get(0).getPostedBy());
    }

    @Test
    public void findRepliesPostedByUserA() {
        this.createData();
        List<Reply> result = this.getReplyDAO().findByIdAndPostedBy("Amazon DynamoDB#DynamoDB Thread 2", USER_A);
        Assert.assertNotNull(result);
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertEquals((String)USER_A, (String)result.get(0).getPostedBy());
    }

    protected void createData() {
        this.getForumDAO().save(new Forum(DYNAMODB_FORUM, "Amazon Web Services", 2, 4, 1000));
        this.getForumDAO().save(new Forum(S3_FORUM, "Amazon Web Services", 1, 0, 0));
        this.getThreadDAO().save(new Thread(DYNAMODB_FORUM, DYNAMODB_THREAD_1, "DynamoDB thread 1 message", USER_A, 10, 2, 0, new HashSet<String>(Arrays.asList("index", "primarykey", "table")), fourteenDaysAgo));
        this.getThreadDAO().save(new Thread(DYNAMODB_FORUM, DYNAMODB_THREAD_2, "DynamoDB thread 2 message", USER_A, 20, 2, 0, new HashSet<String>(Arrays.asList("index", "primarykey", "rangekey")), twentyOneDaysAgo));
        this.getThreadDAO().save(new Thread(S3_FORUM, S3_THREAD_1, "S3 thread 1 message", USER_A, 0, 0, 0, new HashSet<String>(Arrays.asList("largeobjects", "multipart upload")), sevenDaysAgo));
        this.getReplyDAO().save(new Reply("Amazon DynamoDB#DynamoDB Thread 1", "DynamoDB Thread 1 Reply 1 text", USER_A, twentyOneDaysAgo));
        this.getReplyDAO().save(new Reply("Amazon DynamoDB#DynamoDB Thread 1", "DynamoDB Thread 1 Reply 2 text", USER_B, fourteenDaysAgo));
        this.getReplyDAO().save(new Reply("Amazon DynamoDB#DynamoDB Thread 2", "DynamoDB Thread 2 Reply 1 text", USER_A, sevenDaysAgo));
        this.getReplyDAO().save(new Reply("Amazon DynamoDB#DynamoDB Thread 2", "DynamoDB Thread 2 Reply 2 text", USER_A, oneDayAgo));
    }
}

