/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.examples.gamescore;

import java.util.Date;
import org.iternine.jeppetto.dao.test.examples.gamescore.GameScore;
import org.iternine.jeppetto.dao.test.examples.gamescore.GameScoreDAO;
import org.iternine.jeppetto.dao.test.examples.gamescore.UserProgress;
import org.iternine.jeppetto.dao.test.examples.gamescore.UserProgressDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class GameScoreTest {
    protected static final Date oneDayAgo = new Date(new Date().getTime() - 86400000L);
    protected static final Date sevenDaysAgo = new Date(new Date().getTime() - 604800000L);
    protected static final Date fourteenDaysAgo = new Date(new Date().getTime() - 1209600000L);
    protected static final Date twentyOneDaysAgo = new Date(new Date().getTime() - 1814400000L);

    protected abstract GameScoreDAO getGameScoreDAO();

    protected abstract UserProgressDAO getUserProgressDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findTopScores() {
        this.createData();
        Iterable<GameScore> gameScores = this.getGameScoreDAO().findByGameTitleOrderByTopScoreDesc("Galaxy Invaders");
        int lastTopScore = Integer.MAX_VALUE;
        int count = 0;
        for (GameScore gameScore : gameScores) {
            Assert.assertEquals((Object)"Galaxy Invaders", (Object)gameScore.getGameTitle());
            Assert.assertTrue((gameScore.getTopScore() <= lastTopScore ? 1 : 0) != 0);
            lastTopScore = gameScore.getTopScore();
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void findZeroScores() {
        this.createData();
        this.getUserProgressDAO().save(new UserProgress("123", "Comet Quest", 0, oneDayAgo, 0, 1));
        this.getUserProgressDAO().save(new UserProgress("201", "Comet Quest", 0, oneDayAgo, 0, 1));
        this.getUserProgressDAO().save(new UserProgress("301", "Comet Quest", 0, oneDayAgo, 0, 1));
        this.getUserProgressDAO().save(new UserProgress("400", "Comet Quest", 1000, oneDayAgo, 1, 0));
        Iterable<GameScore> gameScores = this.getGameScoreDAO().findByGameTitleAndTopScore("Comet Quest", 0);
        int count = 0;
        for (GameScore gameScore : gameScores) {
            Assert.assertEquals((Object)"Comet Quest", (Object)gameScore.getGameTitle());
            Assert.assertEquals((long)0L, (long)gameScore.getTopScore());
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    private void createData() {
        this.getUserProgressDAO().save(new UserProgress("101", "Galaxy Invaders", 5842, oneDayAgo, 21, 72));
        this.getUserProgressDAO().save(new UserProgress("101", "Meteor Blasters", 1000, sevenDaysAgo, 12, 3));
        this.getUserProgressDAO().save(new UserProgress("101", "Starship X", 24, fourteenDaysAgo, 4, 9));
        this.getUserProgressDAO().save(new UserProgress("102", "Alien Adventure", 192, oneDayAgo, 32, 192));
        this.getUserProgressDAO().save(new UserProgress("102", "Galaxy Invaders", 0, sevenDaysAgo, 0, 5));
        this.getUserProgressDAO().save(new UserProgress("103", "Attack Ships", 3, oneDayAgo, 1, 8));
        this.getUserProgressDAO().save(new UserProgress("103", "Galaxy Invaders", 2317, sevenDaysAgo, 40, 3));
        this.getUserProgressDAO().save(new UserProgress("103", "Meteor Blasters", 723, fourteenDaysAgo, 22, 12));
        this.getUserProgressDAO().save(new UserProgress("103", "Starship X", 42, twentyOneDaysAgo, 4, 19));
    }
}

