/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.core;

import org.iternine.jeppetto.dao.test.RelatedObject;
import org.iternine.jeppetto.dao.test.SimpleObject;
import org.iternine.jeppetto.dao.test.core.ProjectionDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class ProjectionDAOTest {
    protected abstract ProjectionDAO getProjectionDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void countSomeObjects() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countByIntValueLessThan(100));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().countByIntValueLessThan(3));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValueLessThan(2));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().countByIntValueLessThan(1));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().countByIntValue(0));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValue(1));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValue(2));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValue(3));
    }

    @Test
    public void countSomeObjectsUsingAnnotation() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().doAnAnnotationBasedCount(0));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().doAnAnnotationBasedCount(1));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().doAnAnnotationBasedCount(2));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().doAnAnnotationBasedCount(3));
    }

    @Test
    public void countSomeObjectsUsingAnnotationGreaterThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().doAnAnnotationBasedCountGreaterThanEquals(0));
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().doAnAnnotationBasedCountGreaterThanEquals(1));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().doAnAnnotationBasedCountGreaterThanEquals(2));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().doAnAnnotationBasedCountGreaterThanEquals(3));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().doAnAnnotationBasedCountGreaterThanEquals(4));
    }

    @Test
    public void countSomeObjectsUsingDslStyleGreaterThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countByIntValueGreaterThanEqual(0));
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countByIntValueGreaterThanEqual(1));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().countByIntValueGreaterThanEqual(2));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValueGreaterThanEqual(3));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().countByIntValueGreaterThanEqual(4));
    }

    @Test
    public void countSomeObjectsUsingAnnotationLessThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().doAnAnnotationBasedCountLessThanEquals(4));
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().doAnAnnotationBasedCountLessThanEquals(3));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().doAnAnnotationBasedCountLessThanEquals(2));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().doAnAnnotationBasedCountLessThanEquals(1));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().doAnAnnotationBasedCountLessThanEquals(0));
    }

    @Test
    public void countSomeObjectsUsingDslStyleLessThanEquals() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countByIntValueLessThanEqual(4));
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countByIntValueLessThanEqual(3));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().countByIntValueLessThanEqual(2));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countByIntValueLessThanEqual(1));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().countByIntValueLessThanEqual(0));
    }

    @Test
    public void countAll() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countAll());
    }

    @Test
    public void sumIntValues() {
        this.createData();
        Assert.assertEquals((double)6.0, (double)this.getProjectionDAO().sumIntValues(), (double)0.0);
    }

    @Test
    public void averageIntValues() {
        this.createData();
        Assert.assertEquals((double)2.0, (double)this.getProjectionDAO().averageIntValues(), (double)0.0);
    }

    @Test
    public void minIntValue() {
        this.createData();
        Assert.assertEquals((double)1.0, (double)this.getProjectionDAO().minIntValue(), (double)0.0);
    }

    @Test
    public void maxIntValue() {
        this.createData();
        Assert.assertEquals((double)3.0, (double)this.getProjectionDAO().maxIntValue(), (double)0.0);
    }

    @Test
    public void countDistinctIntValue() {
        this.createExtraData();
        Assert.assertEquals((long)5L, (long)this.getProjectionDAO().countAll());
        Assert.assertEquals((long)4L, (long)this.getProjectionDAO().countDistinctAnotherIntValue());
    }

    @Test
    public void countRelatedItems() {
        this.createData();
        Assert.assertEquals((long)3L, (long)this.getProjectionDAO().countRelatedItems(21));
        Assert.assertEquals((long)2L, (long)this.getProjectionDAO().countRelatedItems(20));
        Assert.assertEquals((long)1L, (long)this.getProjectionDAO().countRelatedItems(15));
        Assert.assertEquals((long)0L, (long)this.getProjectionDAO().countRelatedItems(10));
    }

    protected void createData() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        simpleObject.setAnotherIntValue(1);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(20);
        simpleObject.addRelatedObject(relatedObject);
        this.getProjectionDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(2);
        simpleObject.setAnotherIntValue(2);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(15);
        simpleObject.addRelatedObject(relatedObject);
        this.getProjectionDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(3);
        simpleObject.setAnotherIntValue(3);
        relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(10);
        simpleObject.addRelatedObject(relatedObject);
        this.getProjectionDAO().save(simpleObject);
    }

    protected void createExtraData() {
        this.createData();
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(4);
        simpleObject.setAnotherIntValue(4);
        this.getProjectionDAO().save(simpleObject);
        simpleObject = new SimpleObject();
        simpleObject.setIntValue(5);
        simpleObject.setAnotherIntValue(4);
        this.getProjectionDAO().save(simpleObject);
    }
}

