/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.updateobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.iternine.jeppetto.dao.ResultFromUpdate;
import org.iternine.jeppetto.dao.test.RelatedObject;
import org.iternine.jeppetto.dao.test.SimpleEnum;
import org.iternine.jeppetto.dao.test.SimpleObject;
import org.iternine.jeppetto.dao.test.updateobject.SimpleUpdateObject;
import org.iternine.jeppetto.dao.test.updateobject.UpdateObjectDAO;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class UpdateObjectDAOTest {
    protected abstract UpdateObjectDAO getSimpleObjectReferencesDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void updateSimpleFields() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.setLongValue(1L);
        simpleObject.setSimpleEnum(SimpleEnum.EnumValue);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.setLongValue(Long.MAX_VALUE);
        updateObject.setAnotherIntValue(999);
        updateObject.setSimpleEnum(null);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getAnotherIntValue());
        Assert.assertEquals(null, (Object)((Object)resultSimpleObject.getSimpleEnum()));
    }

    @Test
    public void updateSimpleFieldsInMultipleEntities() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(123);
        simpleObject1.setLongValue(1L);
        this.getSimpleObjectReferencesDAO().save(simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(234);
        simpleObject2.setLongValue(2L);
        this.getSimpleObjectReferencesDAO().save(simpleObject2);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.setLongValue(Long.MAX_VALUE);
        updateObject.setAnotherIntValue(999);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject1.getId(), simpleObject2.getId()});
        SimpleObject resultSimpleObject1 = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject1.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject1.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject1.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject1.getAnotherIntValue());
        SimpleObject resultSimpleObject2 = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject2.getId());
        Assert.assertEquals((long)234L, (long)resultSimpleObject2.getIntValue());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)resultSimpleObject2.getLongValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject2.getAnotherIntValue());
    }

    @Test
    public void addNestedObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        updateObject.setRelatedObject(relatedObject);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)123L, (long)resultSimpleObject.getIntValue());
        Assert.assertNotNull((Object)resultSimpleObject.getRelatedObject());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObject().getRelatedIntValue());
    }

    @Test
    public void updateNestedObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        simpleObject.setRelatedObject(relatedObject);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.setIntValue(456);
        RelatedObject relatedUpdateObject = updateObject.getRelatedObject();
        relatedUpdateObject.setRelatedIntValue(999);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getIntValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getRelatedObject().getRelatedIntValue());
    }

    @Test
    public void addNewList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        updateObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void addToExistingList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        List<RelatedObject> relatedObjectUpdate = updateObject.getRelatedObjects();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        relatedObjectUpdate.add(relatedObject2);
        RelatedObject relatedObject3 = new RelatedObject();
        relatedObject3.setRelatedIntValue(999);
        relatedObjectUpdate.add(relatedObject3);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)3L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(1).getRelatedIntValue());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getRelatedObjects().get(2).getRelatedIntValue());
    }

    @Test
    public void setAtIndex() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjects().set(3, relatedObject2);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)456L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
        if (resultSimpleObject.getRelatedObjects().size() == 2) {
            Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(1).getRelatedIntValue());
        } else {
            Assert.assertEquals((long)4L, (long)resultSimpleObject.getRelatedObjects().size());
            Assert.assertNull((Object)resultSimpleObject.getRelatedObjects().get(1));
            Assert.assertNull((Object)resultSimpleObject.getRelatedObjects().get(2));
            Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(3).getRelatedIntValue());
        }
    }

    @Test
    public void removeFromExistingList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject1 = new RelatedObject();
        relatedObject1.setRelatedIntValue(456);
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject1);
        relatedObjects.add(relatedObject2);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        List<RelatedObject> relatedObjectUpdate = updateObject.getRelatedObjects();
        relatedObjectUpdate.remove(relatedObject1);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void removeFromExistingListUsingIndex() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject1 = new RelatedObject();
        relatedObject1.setRelatedIntValue(456);
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject1);
        relatedObjects.add(relatedObject2);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        List<RelatedObject> relatedObjectUpdate = updateObject.getRelatedObjects();
        relatedObjectUpdate.remove(0);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void clearList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.getRelatedObjects().clear();
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)0L, (long)resultSimpleObject.getRelatedObjects().size());
    }

    @Test
    public void clearAndAddToList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        ArrayList<RelatedObject> relatedObjects = new ArrayList<RelatedObject>();
        relatedObjects.add(relatedObject);
        simpleObject.setRelatedObjects(relatedObjects);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.getRelatedObjects().clear();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjects().add(relatedObject2);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjects());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjects().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjects().get(0).getRelatedIntValue());
    }

    @Test
    public void clearMap() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        HashMap<String, RelatedObject> relatedObjectMap = new HashMap<String, RelatedObject>();
        relatedObjectMap.put("one", relatedObject);
        simpleObject.setRelatedObjectMap(relatedObjectMap);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.getRelatedObjectMap().clear();
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjectMap());
        Assert.assertEquals((long)0L, (long)resultSimpleObject.getRelatedObjectMap().size());
    }

    @Test
    public void clearAndAddToMap() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(456);
        HashMap<String, RelatedObject> relatedObjectMap = new HashMap<String, RelatedObject>();
        relatedObjectMap.put("one", relatedObject);
        simpleObject.setRelatedObjectMap(relatedObjectMap);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.getRelatedObjectMap().clear();
        RelatedObject relatedObject2 = new RelatedObject();
        relatedObject2.setRelatedIntValue(789);
        updateObject.getRelatedObjectMap().put("two", relatedObject2);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getRelatedObjectMap());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getRelatedObjectMap().size());
        Assert.assertEquals((long)789L, (long)resultSimpleObject.getRelatedObjectMap().get("two").getRelatedIntValue());
    }

    @Test
    public void addStringsToList() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.addToStringList("duck");
        simpleObject.addToStringList("bunny");
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        List<String> updateList = updateObject.getStringList();
        updateList.add("bunny");
        updateList.add("cow");
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getStringList());
        Assert.assertEquals((long)4L, (long)resultSimpleObject.getStringList().size());
        Assert.assertEquals((Object)"duck", (Object)resultSimpleObject.getStringList().get(0));
        Assert.assertEquals((Object)"bunny", (Object)resultSimpleObject.getStringList().get(1));
        Assert.assertEquals((Object)"bunny", (Object)resultSimpleObject.getStringList().get(2));
        Assert.assertEquals((Object)"cow", (Object)resultSimpleObject.getStringList().get(3));
    }

    @Test
    public void addStringsToSet() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        simpleObject.addToStringSet("duck");
        simpleObject.addToStringSet("bunny");
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        Set<String> updateSet = updateObject.getStringSet();
        updateSet.add("bunny");
        updateSet.add("cow");
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertNotNull(resultSimpleObject.getStringSet());
        Assert.assertEquals((long)3L, (long)resultSimpleObject.getStringSet().size());
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("duck"));
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("bunny"));
        Assert.assertTrue((boolean)resultSimpleObject.getStringSet().contains("cow"));
    }

    @Test
    public void updateByOtherField() {
        SimpleObject simpleObject1 = new SimpleObject();
        simpleObject1.setIntValue(123);
        simpleObject1.setAnotherIntValue(-1);
        this.getSimpleObjectReferencesDAO().save(simpleObject1);
        SimpleObject simpleObject2 = new SimpleObject();
        simpleObject2.setIntValue(234);
        simpleObject2.setAnotherIntValue(-1);
        this.getSimpleObjectReferencesDAO().save(simpleObject2);
        SimpleObject updateObject = (SimpleObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.setAnotherIntValue(42);
        this.getSimpleObjectReferencesDAO().updateByAnotherIntValue(updateObject, -1);
        Iterable results = this.getSimpleObjectReferencesDAO().findAll();
        int resultCount = 0;
        for (SimpleObject result : results) {
            Assert.assertEquals((long)42L, (long)result.getAnotherIntValue());
            Assert.assertTrue((result.getIntValue() == 123 || result.getIntValue() == 234 ? 1 : 0) != 0);
            ++resultCount;
        }
        Assert.assertEquals((long)2L, (long)resultCount);
    }

    @Test
    public void incrementIntValue() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToIntValue(1);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)2L, (long)resultSimpleObject.getIntValue());
    }

    @Test
    public void decrementIntValue() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(100);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToIntValue(-5);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)95L, (long)resultSimpleObject.getIntValue());
    }

    @Test
    public void incrementLongValue() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setLongValue(1L);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToLongValue(100L);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)101L, (long)resultSimpleObject.getLongValue());
    }

    @Test
    public void incrementDoubleValue() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setDoubleValue(1.5);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToDoubleValue(2.25);
        this.getSimpleObjectReferencesDAO().updateByIds(updateObject, new String[]{simpleObject.getId()});
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().findById(simpleObject.getId());
        Assert.assertEquals((double)3.75, (double)resultSimpleObject.getDoubleValue(), (double)1.0E-4);
    }

    @Test
    public void incrementIntValueAndReturnAfterModified() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToIntValue(1);
        updateObject.setResultFromUpdate(ResultFromUpdate.ReturnPostUpdate);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().updateById(updateObject, simpleObject.getId());
        Assert.assertEquals((long)2L, (long)resultSimpleObject.getIntValue());
    }

    @Test
    public void incrementIntValueAndReturnBeforeModified() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToIntValue(1);
        updateObject.setResultFromUpdate(ResultFromUpdate.ReturnPreUpdate);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().updateById(updateObject, simpleObject.getId());
        Assert.assertEquals((long)1L, (long)resultSimpleObject.getIntValue());
    }

    @Test
    public void incrementIntValueAndReturnNone() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(1);
        this.getSimpleObjectReferencesDAO().save(simpleObject);
        SimpleUpdateObject updateObject = (SimpleUpdateObject)this.getSimpleObjectReferencesDAO().getUpdateObject();
        updateObject.addToIntValue(1);
        updateObject.setResultFromUpdate(ResultFromUpdate.ReturnNone);
        SimpleObject resultSimpleObject = (SimpleObject)this.getSimpleObjectReferencesDAO().updateById(updateObject, simpleObject.getId());
        Assert.assertNull((Object)resultSimpleObject);
    }
}

