/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.dao.test.view;

import java.util.HashSet;
import org.iternine.jeppetto.dao.NoSuchItemException;
import org.iternine.jeppetto.dao.test.RelatedObject;
import org.iternine.jeppetto.dao.test.SimpleObject;
import org.iternine.jeppetto.dao.test.core.DynamicDAO;
import org.iternine.jeppetto.dao.test.view.SummaryDAO;
import org.iternine.jeppetto.dao.test.view.SummarySimpleObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class SummaryDAOTest {
    protected abstract DynamicDAO getDynamicDAO();

    protected abstract SummaryDAO getSummaryDAO();

    protected abstract void reset();

    @After
    public void after() {
        this.reset();
    }

    @Test
    public void findById() throws NoSuchItemException {
        RelatedObject relatedObject = new RelatedObject();
        relatedObject.setRelatedIntValue(20);
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setRelatedObject(relatedObject);
        simpleObject.addRelatedObject(relatedObject);
        this.getDynamicDAO().save(simpleObject);
        SummarySimpleObject summarySimpleObject = (SummarySimpleObject)this.getSummaryDAO().findById(simpleObject.getId());
        Assert.assertEquals((Object)simpleObject.getId(), (Object)summarySimpleObject.getId());
        Assert.assertEquals((long)simpleObject.getRelatedObject().getRelatedIntValue(), (long)summarySimpleObject.getRelatedObject().getRelatedIntValue());
        Assert.assertEquals((long)1L, (long)summarySimpleObject.getRelatedObjects().size());
    }

    @Test
    public void updateSummaryObject() {
        SimpleObject simpleObject = new SimpleObject();
        simpleObject.setIntValue(123);
        this.getDynamicDAO().save(simpleObject);
        SummarySimpleObject summarySimpleObject = (SummarySimpleObject)this.getSummaryDAO().findById(simpleObject.getId());
        summarySimpleObject.setIntValue(999);
        this.getSummaryDAO().save(summarySimpleObject);
        SummarySimpleObject resultSummarySimpleObject = (SummarySimpleObject)this.getSummaryDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)999L, (long)resultSummarySimpleObject.getIntValue());
        SimpleObject resultSimpleObject = (SimpleObject)this.getDynamicDAO().findById(simpleObject.getId());
        Assert.assertEquals((long)999L, (long)resultSimpleObject.getIntValue());
    }

    @Test
    public void findMultiple() {
        HashSet<Integer> intValues = new HashSet<Integer>(10);
        for (int i = 0; i < 10; ++i) {
            SimpleObject simpleObject = new SimpleObject();
            simpleObject.setIntValue(i);
            this.getDynamicDAO().save(simpleObject);
            intValues.add(i);
        }
        Iterable results = this.getSummaryDAO().findAll();
        for (SummarySimpleObject result : results) {
            intValues.remove(result.getIntValue());
        }
        Assert.assertEquals((long)0L, (long)intValues.size());
    }

    @Test
    public void findMultipleById() {
        HashSet<String> ids = new HashSet<String>(3);
        for (int i = 0; i < 3; ++i) {
            SimpleObject simpleObject = new SimpleObject();
            simpleObject.setIntValue(i);
            this.getDynamicDAO().save(simpleObject);
            ids.add(simpleObject.getId());
        }
        Iterable results = this.getSummaryDAO().findByIds(ids.toArray(new String[3]));
        for (SummarySimpleObject result : results) {
            ids.remove(result.getId());
        }
        Assert.assertEquals((long)0L, (long)ids.size());
    }
}

