/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.iternine.jeppetto.testsupport.DatabaseProvider;
import org.iternine.jeppetto.testsupport.db.ConnectionSource;
import org.iternine.jeppetto.testsupport.db.DataSourceConnectionSource;
import org.iternine.jeppetto.testsupport.db.Database;
import org.iternine.jeppetto.testsupport.db.DatabaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class JdbcDatabaseProvider
implements DatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDatabaseProvider.class);
    private String driverClassNameProperty;

    public JdbcDatabaseProvider(String driverClassNameProperty) {
        this.driverClassNameProperty = driverClassNameProperty;
    }

    @Override
    public Properties modifyProperties(Properties properties) {
        return properties;
    }

    @Override
    public Database getDatabase(Properties properties, ApplicationContext applicationContext) {
        ConnectionSource connectionSource = this.getConnectionSource(properties, applicationContext);
        if (connectionSource != null) {
            return DatabaseFactory.getDatabase(connectionSource);
        }
        return null;
    }

    private ConnectionSource getConnectionSource(Properties properties, ApplicationContext applicationContext) {
        Map datasourceBeans = applicationContext.getBeansOfType(DataSource.class);
        if (datasourceBeans.size() == 0) {
            return null;
        }
        if (datasourceBeans.size() > 1) {
            logger.warn("NOTE: Found more than one bean of type 'DataSource'.  Selecting random from the following: {}", (Object)datasourceBeans);
        }
        DataSource dataSource = (DataSource)datasourceBeans.values().iterator().next();
        return new DataSourceConnectionSource(dataSource, (String)properties.get(this.driverClassNameProperty));
    }
}

