/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.iternine.jeppetto.testsupport.DatabaseProvider;
import org.iternine.jeppetto.testsupport.db.Database;
import org.iternine.jeppetto.testsupport.db.MongoDatabase;
import org.springframework.context.ApplicationContext;

public class MongoDatabaseProvider
implements DatabaseProvider,
Closeable {
    private static final String MONGODB_PORT_PROPERTY = "mongodb.left.port";
    private static final String BACKUP_MONGODB_PORT_PROPERTY = "mongodb.port";
    private static final String MONGODB_NAME_PROPERTY = "mongodb.dbname";
    private MongoDatabase db;
    private String mongoPortProperty;
    private String mongoDbNameProperty;
    private boolean uniquifyName;

    public MongoDatabaseProvider() {
        this(true);
    }

    public MongoDatabaseProvider(boolean uniquifyName) {
        this(MONGODB_PORT_PROPERTY, MONGODB_NAME_PROPERTY, uniquifyName);
    }

    public MongoDatabaseProvider(String mongoPortProperty, String mongoDbNameProperty, boolean uniquifyName) {
        this.mongoPortProperty = mongoPortProperty;
        this.mongoDbNameProperty = mongoDbNameProperty;
        this.uniquifyName = uniquifyName;
    }

    @Override
    public Properties modifyProperties(Properties properties) {
        String mongoDbName;
        int mongoDbPort;
        try {
            mongoDbPort = Integer.parseInt(properties.getProperty(this.mongoPortProperty));
        }
        catch (NumberFormatException nfe) {
            mongoDbPort = Integer.parseInt(properties.getProperty(BACKUP_MONGODB_PORT_PROPERTY));
        }
        if (this.uniquifyName) {
            String baseName = properties.getProperty(this.mongoDbNameProperty);
            mongoDbName = String.format("%s_%s", baseName, UUID.randomUUID().toString().substring(0, 3));
            properties.setProperty(this.mongoDbNameProperty, mongoDbName);
        } else {
            mongoDbName = properties.getProperty(this.mongoDbNameProperty);
        }
        this.db = MongoDatabase.forPlatform(mongoDbPort);
        this.db.setMongoDbName(mongoDbName);
        return properties;
    }

    @Override
    public Database getDatabase(Properties properties, ApplicationContext applicationContext) {
        return this.db;
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
        }
    }
}

