/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileSystemFixtureSupport {
    private File rootDir;
    private Set<File> fixtureFiles = new HashSet<File>();

    public FileSystemFixtureSupport(String prefix) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.rootDir = null;
        do {
            this.rootDir = new File(tmpDir + File.separator + prefix + System.currentTimeMillis() + new Random().nextInt());
        } while (this.rootDir.exists());
        this.createDirectoryOrThrow(this.rootDir);
    }

    public FileSystemFixtureSupport(File rootDir) {
        this.rootDir = rootDir;
        if (!rootDir.exists()) {
            this.createDirectoryOrThrow(rootDir);
        }
    }

    public File createDirectory(String path) {
        this.verifyNotDestroyed();
        File newDirectory = new File(this.rootDir + File.separator + path);
        this.fixtureFiles.add(newDirectory);
        return newDirectory;
    }

    public void loadFileFixtures(List<String> resourcesToLoad) throws IOException {
        this.verifyNotDestroyed();
        for (String resource : resourcesToLoad) {
            this.loadTestFixtureFromClasspath(resource);
        }
    }

    public void teardown() throws IOException {
        this.verifyNotDestroyed();
        ArrayList<String> filesThatWouldnotDelete = new ArrayList<String>();
        for (File fixtureFile : this.fixtureFiles) {
            if (!fixtureFile.exists() || this.deleteFile(fixtureFile)) continue;
            filesThatWouldnotDelete.add(fixtureFile.getAbsolutePath());
        }
        this.fixtureFiles.clear();
        if (!filesThatWouldnotDelete.isEmpty()) {
            throw new IOException("Unable to delete the following files: " + filesThatWouldnotDelete);
        }
    }

    public void destroy() throws IOException {
        this.teardown();
        if (!this.deleteFile(this.rootDir)) {
            throw new RuntimeException("Unable to delete contents of directory " + this.rootDir);
        }
        this.rootDir = null;
    }

    public File getTestingRoot() {
        this.verifyNotDestroyed();
        return this.rootDir;
    }

    private void createDirectoryOrThrow(File dir) {
        if (!dir.mkdirs()) {
            throw new RuntimeException("Unable to create the specified directory " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestFixtureFromClasspath(String resourceName) throws IOException {
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutStream = null;
        try {
            zipInputStream = new ZipInputStream(ClassLoader.getSystemResourceAsStream(resourceName));
            ZipEntry nextEntry = null;
            while ((nextEntry = zipInputStream.getNextEntry()) != null) {
                String entryPath = nextEntry.getName();
                File outFile = new File(this.rootDir.getAbsolutePath() + File.separator + entryPath);
                if (!outFile.getParentFile().exists()) {
                    this.createDirectoryOrThrow(outFile.getParentFile());
                }
                fileOutStream = new FileOutputStream(outFile);
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                    fileOutStream.write(buffer, 0, read);
                }
                fileOutStream.close();
                fileOutStream = null;
                this.fixtureFiles.add(outFile);
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (fileOutStream != null) {
                fileOutStream.close();
            }
        }
    }

    private boolean deleteFile(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteFile(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return file.delete();
    }

    private void verifyNotDestroyed() {
        if (this.rootDir == null) {
            throw new IllegalStateException("Fixture has already been destroyed.");
        }
    }
}

