/*
 * Decompiled with CFR 0.152.
 */
package org.itest.scenario;

import java.lang.reflect.Field;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.itest.ITestConfig;
import org.itest.ITestContext;
import org.itest.exception.ITestException;
import org.itest.impl.ITestContextImpl;
import org.itest.param.ITestParamState;
import org.itest.scenario.ITestScenario;
import org.itest.scenario.ITestScenarioAction;
import org.itest.scenario.ITestScenarioEnvironment;
import org.itest.scenario.ITestScenarioExperiment;
import org.itest.scenario.ITestScenarioParamsHolder;

public class ITestScenarioExecUtil {
    public static <ENV extends ITestScenarioEnvironment, A extends ITestScenarioAction, S extends ITestScenario<A>, EXP extends ITestScenarioExperiment<A, S>> void executeExperiment(Class<EXP> expClass, String expName, ENV env, ITestConfig iTestConfig) {
        ITestScenarioExperiment experiment = (ITestScenarioExperiment)ITestScenarioExecUtil.generateITestObject(expClass, expName, iTestConfig);
        for (ITestScenario.Action o : experiment.getScenario().getActions()) {
            ITestScenario.Action action = o;
            if (null == action.getParams()) {
                throw new ITestException("Params not specified for action:" + action);
            }
            Object[] args = new Object[action.getParams().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ITestScenarioExecUtil.parseParamValue(experiment.getParams(), action.getParams()[i]);
            }
            Object result = env.execute((ITestScenarioAction)action.getITestAction(), args);
            if (null == action.getResult()) continue;
            experiment.getParams().setField(action.getResult(), result);
        }
    }

    public static <T> T generateITestObject(Class<T> clazz, String name, ITestConfig iTestConfig) {
        ITestParamState param = iTestConfig.getITestParamLoader().loadITestParam(clazz, name).getElement("T");
        return (T)iTestConfig.getITestObjectGenerator().generate(clazz, param, Collections.EMPTY_MAP, (ITestContext)new ITestContextImpl(param, Collections.EMPTY_MAP));
    }

    private static Object parseParamValue(ITestScenarioParamsHolder params, String paramName) {
        if (null == paramName) {
            return null;
        }
        String[] paramNames = StringUtils.split((String)paramName, (char)'.');
        Object paramValue = params.getField(paramNames[0]);
        for (int i = 1; i < paramNames.length; ++i) {
            paramValue = ITestScenarioExecUtil.getObjectProperty(paramValue, paramNames[i]);
        }
        return paramValue;
    }

    private static Object getObjectProperty(Object paramValue, String paramName) {
        if (null == paramValue) {
            return null;
        }
        Class<?> clazz = paramValue.getClass();
        Field f = null;
        do {
            try {
                f = clazz.getDeclaredField(paramName);
                f.setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (null != (clazz = clazz.getSuperclass()));
        try {
            return f.get(paramValue);
        }
        catch (IllegalAccessException e) {
            throw new ITestException("Error accessing " + f + " for object of " + clazz);
        }
    }
}

