/*
 * Decompiled with CFR 0.152.
 */
package org.itest.scenario;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.itest.ITestConfig;
import org.itest.ITestContext;
import org.itest.exception.ITestException;
import org.itest.impl.ITestContextImpl;
import org.itest.param.ITestParamState;
import org.itest.scenario.ITestScenario;
import org.itest.scenario.ITestScenarioAction;
import org.itest.scenario.ITestScenarioEnvironment;
import org.itest.scenario.ITestScenarioExperiment;
import org.itest.scenario.util.ITestSuperObjectHolder;
import org.itest.verify.ITestFieldVerificationResult;

public class ITestScenarioExecUtil {
    public static <ENV extends ITestScenarioEnvironment, A extends ITestScenarioAction, S extends ITestScenario<A>, EXP extends ITestScenarioExperiment<A, S>> Collection<ITestFieldVerificationResult> executeExperiment(Class<EXP> expClass, String expName, ENV env, ITestConfig iTestConfig) {
        ITestScenarioExperiment experiment = (ITestScenarioExperiment)ITestScenarioExecUtil.generateITestObject(expClass, expName, iTestConfig);
        ArrayList<ITestFieldVerificationResult> res = new ArrayList<ITestFieldVerificationResult>();
        for (Map.Entry<String, ITestScenario.Action> e : experiment.getScenario().getActions().entrySet()) {
            Map.Entry<String, ITestScenario.Action> entry = e;
            ITestScenario.Action action = entry.getValue();
            if (null == action.getParams()) {
                throw new ITestException("Params not specified for action:" + action);
            }
            Object[] args = new Object[action.getParams().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ITestScenarioExecUtil.parseParamValue(experiment.getParams(), action.getParams()[i]);
            }
            Object result = env.execute(entry.getKey(), (ITestScenarioAction)action.getITestAction(), args);
            if (null != action.getResult()) {
                experiment.getParams().setField(action.getResult(), result);
            }
            ITestParamState verifier = (ITestParamState)experiment.getVerifiers().getField(entry.getKey());
            Collection<ITestFieldVerificationResult> verifyRes = ITestScenarioExecUtil.verify(expName + "." + entry.getKey(), result, action.getVerify(), verifier, iTestConfig);
            if (null == verifyRes) continue;
            res.addAll(verifyRes);
        }
        return res;
    }

    private static Collection<ITestFieldVerificationResult> verify(String name, Object object, ITestParamState scenarioVerify, ITestParamState expVerify, ITestConfig iTestConfig) {
        Collection res = null;
        if (null != expVerify) {
            res = iTestConfig.getITestExecutionVerifier().verify("experiment:" + name, object, expVerify);
        } else if (null != scenarioVerify) {
            res = iTestConfig.getITestExecutionVerifier().verify("scenario:" + name, object, scenarioVerify);
        }
        return res;
    }

    public static <T> T generateITestObject(Class<T> clazz, String name, ITestConfig iTestConfig) {
        ITestParamState param = iTestConfig.getITestParamLoader().loadITestParam(clazz, name).getElement("T");
        return (T)iTestConfig.getITestObjectGenerator().generate(clazz, param, Collections.EMPTY_MAP, (ITestContext)new ITestContextImpl(param, Collections.EMPTY_MAP));
    }

    private static Object parseParamValue(ITestSuperObjectHolder<Object> params, String paramName) {
        if (null == paramName) {
            return null;
        }
        String[] paramNames = StringUtils.split((String)paramName, (char)'.');
        Object paramValue = params.getField(paramNames[0]);
        for (int i = 1; i < paramNames.length; ++i) {
            paramValue = ITestScenarioExecUtil.getObjectProperty(paramValue, paramNames[i]);
        }
        return paramValue;
    }

    private static Object getObjectProperty(Object paramValue, String paramName) {
        if (null == paramValue) {
            return null;
        }
        Class<?> clazz = paramValue.getClass();
        Field f = null;
        do {
            try {
                f = clazz.getDeclaredField(paramName);
                f.setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (null != (clazz = clazz.getSuperclass()));
        try {
            return f.get(paramValue);
        }
        catch (IllegalAccessException e) {
            throw new ITestException("Error accessing " + f + " for object of " + clazz);
        }
    }
}

