/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.whiterabbit.api;

import java.util.Optional;
import org.itsallcode.whiterabbit.api.Plugin;
import org.itsallcode.whiterabbit.api.PluginConfiguration;
import org.itsallcode.whiterabbit.api.features.PluginFeature;

public abstract class AbstractPlugin<S extends PluginFeature>
implements Plugin {
    private final String id;
    private final Class<S> featureType;
    protected PluginConfiguration config;

    protected AbstractPlugin(String id, Class<S> featureType) {
        this.featureType = featureType;
        this.id = id;
    }

    @Override
    public void init(PluginConfiguration config) {
        this.config = config;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public void close() {
    }

    @Override
    public final boolean supports(Class<? extends PluginFeature> featureType) {
        return this.featureType.isAssignableFrom(featureType);
    }

    protected abstract S createInstance();

    @Override
    public final <T extends PluginFeature> Optional<T> getFeature(Class<T> featureType) {
        if (this.supports(featureType)) {
            return Optional.of((PluginFeature)featureType.cast(this.createInstance()));
        }
        return Optional.empty();
    }
}

