package org.iworkz.genesis;

/**
 * Builds the graphs of objects. The injector tracks the dependencies
 * for each type and uses bindings to inject them.
 *
 */
public interface Injector {

	/**
	 * Injects dependencies into the fields and methods of {@code instance}.
	 * An injectable constructor is ignored.
	 * 
	 * @param instance
	 */
	void injectMembers(Object instance);
	
	/**
	 * Returns the appropriate instance for the given {@code type}
	 * 
	 * @param type
	 * @return
	 */
	<T> T getInstance(Class<T> type);
	
	/**
	 * Returns the appropriate instance for the given name
	 * 
	 * @param className
	 * @return
	 */
	<T> T getInstance(String className);
	
	/**
	 * Returns the implementation class for the given {@code type}
	 * 
	 * @param typ 
	 * @return
	 */
	<T> Class<? extends T> getImplementationClass(Class<T> typ);
	
	/**
	 * Returns the implementation class for the given name
	 * 
	 * @param className 
	 * @return
	 */
	<T> Class<? extends T> getImplementationClass(String className);

}
