package org.iworkz.genesis;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

import org.iworkz.genesis.impl.DefaultInjectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public interface InjectorFactory {
	

	static Injector createInjector(Module... modules) {
		
		final Logger logger = LoggerFactory.getLogger(InjectorFactory.class);

		ServiceLoader<InjectorFactory> serviceLoader = ServiceLoader.load(InjectorFactory.class);
		List<InjectorFactory> injectorFactoryList = new ArrayList<>();
		for (InjectorFactory provider : serviceLoader) {
			injectorFactoryList.add(provider);
		}

		InjectorFactory injectorFactory;
		if (!injectorFactoryList.isEmpty()) {
			injectorFactory = injectorFactoryList.get(0);
			logger.info("Injector factory loaded by ServiceLoader: {}", injectorFactory.getClass().getCanonicalName());
		} else {
			logger.info("Default injector factory created: {}", DefaultInjectorFactory.class.getCanonicalName());
			injectorFactory = new DefaultInjectorFactory();
		}

		injectorFactory.registerModules(modules);
		return injectorFactory.getInjector();
	}

	void registerModules(Module... modules);

	Injector getInjector();

}
