package org.iworkz.genesis;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.iworkz.genesis.impl.Binding;
import org.iworkz.genesis.impl.ImplementationFinder;
import org.iworkz.genesis.impl.scope.ScopeContext;

public interface Module {
	
	void configure();
	
	Map<Class<?>, Binding<?>> getBindings();
	Map<Class<?>, ScopeContext> getScopes();
	List<Class<? extends Annotation>> getSingletonScopes();
	Map<Class<? extends Annotation>, ValueSupplier<?,?>> getValueSuppliers();
	
	Set<ClassLoader> getClassLoaders();
	Set<ImplementationClassProcessor> getImplementationClassProcessors();
	Set<ImplementationFinder> getImplementationFinders();
	Set<PostProcessor> getPostProcessors();
	
	void setRanking(int ranking);
	int getRanking();
	
	Set<Module> getDependencies();

}
