package org.iworkz.genesis.impl;

import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBundleInjectorFactory extends AbstractInjectorFactory {
	
	private final static Logger logger = LoggerFactory.getLogger(AbstractBundleInjectorFactory.class);
	
	protected ServiceRegistration<Injector> injectorRegistration;
	

	public AbstractBundleInjectorFactory() {
	}
	
	@Override
	protected void updateInjector() {
		super.updateInjector();
		unregisterInjector();
		registerInjector();
	}
	
	protected void unregisterInjector() {
		if (injectorRegistration != null) {
			injectorRegistration.unregister();
			injectorRegistration = null;
		}
	}
	
	protected void registerInjector() {
			
		if (registeredModules != null) {
			for (Module module : registeredModules) {
				logger.debug("Registered module {}", module.getClass().getCanonicalName());
			}
		}
		
		ServiceFactory<Injector> injectorServiceFactory = new ServiceFactory<Injector>() {
			@Override
			public Injector getService(Bundle bundle, ServiceRegistration<Injector> registration) {
				return getInjector(bundle,registration);
			}
			
			@Override
			public void ungetService(Bundle bundle, ServiceRegistration<Injector> registration, Injector injector) {
				ungetInjector(bundle,registration,injector);
			}
		};
		BundleContext context = FrameworkUtil.getBundle(getClass()).getBundleContext();
		injectorRegistration = context.registerService(Injector.class, injectorServiceFactory, null);
	}
	


	protected Injector getInjector(Bundle bundle, ServiceRegistration<Injector> registration) {
		return getInjector();
	}
	
	protected void ungetInjector(Bundle bundle, ServiceRegistration<Injector> registration, Injector injector) {
	}

}
