package org.iworkz.genesis.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class Binding<T> {

	protected final Class<T> singletonClass;
	protected Class<? extends T> implementationClass;
	protected T instance;
	protected Class<? extends Annotation> scope;

	protected Map<String,Binding<T>> nameBindings;
	protected Map<Class<? extends Annotation>,Binding<T>> annotationClassBindings;
	
	public Binding(Class<T> singletonClass) {
		this.singletonClass = singletonClass;
	}
	
	public Binding<T> annotatedWith(String name) {
		return annotatedWithName(name);
	}
	
	public Binding<T> annotatedWithName(String name) {
		if (nameBindings == null) {
			nameBindings = new HashMap<>();
		}
		Binding<T> annotationBinding = nameBindings.get(name);
		if (annotationBinding == null) {
			annotationBinding = new Binding<>(singletonClass);
			nameBindings.put(name, annotationBinding);
		}
		return annotationBinding;
	}
	
	public Binding<T> annotatedWith(Class<? extends Annotation> annotationClass) {
		if (annotationClassBindings == null) {
			annotationClassBindings = new HashMap<>();
		}
		Binding<T> annotationClassBinding = annotationClassBindings.get(annotationClass);
		if (annotationClassBinding == null) {
			annotationClassBinding = new Binding<>(singletonClass);
			annotationClassBindings.put(annotationClass, annotationClassBinding);
		}
		return annotationClassBinding;
	}

	public Binding<T> to(Class<? extends T> implementationClass) {
		this.implementationClass = implementationClass;
		instance = null;
		return this;
	}

	public void toInstance(T instance) {
		this.instance = instance;
		implementationClass = null;
	}

	public T getInstance() {
		return instance;
	}

	public void in(Class<? extends Annotation> scopeAnnotationClass) {
		this.scope = scopeAnnotationClass;
	}
	
	public Class<? extends Annotation> getScope() {
		return scope;
	}

}
