package org.iworkz.genesis.impl;

import java.util.Map;

import org.iworkz.genesis.InjectorFactory;
import org.iworkz.genesis.Module;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@Component(service = InjectorFactory.class, immediate = true, configurationPid = DefaultBundleInjectorFactory.CONFIGURATION_PID, configurationPolicy = ConfigurationPolicy.REQUIRE) 
public class DefaultBundleInjectorFactory extends AbstractBundleInjectorFactory {
	
	public static final String CONFIGURATION_PID = "org.iworkz.genesis.DefaultBundleInjectorFactory";
	public static final String ENABLE_DYNAMIC_MODULE_REGISTRATION = "enableDynamicModuleRegistration";
	
	private static final Logger logger = LoggerFactory.getLogger(DefaultBundleInjectorFactory.class);
	
	private boolean enableDynamicModuleRegistration=true;

	public DefaultBundleInjectorFactory() {
	}
	
	@Override
	@Reference(cardinality = ReferenceCardinality.MULTIPLE, policy = ReferencePolicy.DYNAMIC, unbind = "unregisterModule")
	public void registerModule(Module module) {
		super.registerModule(module);
	}

	@Override
	public void unregisterModule(Module module) {
		super.unregisterModule(module);
	}
	
	@Modified
	public void modified(Map<String, Object> properties) {
		updateConfiguration(properties);
	}
	
	protected void updateConfiguration(Map<String, Object> properties) {
		synchronized (registeredModules) {
			if (properties != null) {
				logger.debug("Configuration modified: {}", properties);
				Boolean flag = (Boolean)properties.get(ENABLE_DYNAMIC_MODULE_REGISTRATION);
				if (flag != null && enableDynamicModuleRegistration != flag) {
					enableDynamicModuleRegistration = flag;
					if (flag) {
						logger.info("Dynamic module registration is enabled");
					} else {
						logger.info("Dynamic module registration is disabled");
					}
					updateInjector();
				}
			}
		}
	}
	
	@Override
	protected void registerInjector() {
		if (enableDynamicModuleRegistration) {
			super.registerInjector();
		}
	}
	
    @Activate
    public void activate(BundleContext context, Map<String, Object> properties) throws Exception {
    		logger.info("activate '{}'", getClass().getCanonicalName());
    		updateConfiguration(properties);
    }

    @Deactivate
    public void deactivate(BundleContext context) throws Exception {
    		logger.info("deactivate '{}", getClass().getCanonicalName());              
    }

}
