package org.iworkz.genesis.impl;

import org.iworkz.genesis.Injector;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectedServiceFactory<T> implements ServiceFactory<T> {
	
	private static final Logger logger = LoggerFactory.getLogger(InjectedServiceFactory.class);

	private T instance;

	protected final Injector injector;
	protected final Class<T> serviceClass;

	public InjectedServiceFactory(Injector injector, Class<T> serviceClass) {
		logger.debug("create injected service factory for '{}'", serviceClass.getCanonicalName());
		this.injector = injector;
		this.serviceClass = serviceClass;
	}

	@Override
	public T getService(Bundle bundle, ServiceRegistration<T> registration) {
		if (instance == null) {
			instance = injector.getInstance(serviceClass);
			logger.debug("get injected service '{}'", instance.getClass().getCanonicalName());
		}
		return instance;
	}

	@Override
	public void ungetService(Bundle bundle, ServiceRegistration<T> registration, T service) {
	}

}
