package org.iworkz.genesis.impl;

import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class InjectionContext {
	
	protected final Deque<Class<?>> creationStack = new LinkedList<>();
	protected final Map<Object,Set<Object>> createdInstances = new IdentityHashMap<>();
	
	public void putInjectedObject(Object instance, Object injectedObject) {
		
		Set<Object> injectedObjects = createdInstances.computeIfAbsent(instance, i -> new HashSet<>());
		injectedObjects.add(injectedObject);
	}
	
	public void putInjectedObjects(Object instance, Object[] injectedObjectArray) {
		if (injectedObjectArray != null && injectedObjectArray.length > 0) {
			Set<Object> injectedObjects = createdInstances.computeIfAbsent(instance, i -> new HashSet<>());
			for (Object injectedObject : injectedObjectArray) {
				injectedObjects.add(injectedObject);
			}
		}
	}

}
