/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.iworkz.common.exception.GenesisException;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.genesis.ImplementationClassProcessor;
import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.PostProcessor;
import org.iworkz.genesis.ValueSupplier;
import org.iworkz.genesis.impl.AbstractImplementationFinder;
import org.iworkz.genesis.impl.Binding;
import org.iworkz.genesis.impl.ImplementationFinder;
import org.iworkz.genesis.impl.InjectionContext;
import org.iworkz.genesis.impl.Supplier;
import org.iworkz.genesis.impl.scope.ScopeContext;

public abstract class AbstractInjector
implements Injector {
    private ReflectionHelper reflectionHelper;
    private Map<Class<?>, Supplier<?>> suppliers;
    private Map<Class<?>, Binding<?>> bindings;
    private Map<Class<? extends Annotation>, ValueSupplier<?, ?>> valueSuppliers;
    private Set<Class<? extends Annotation>> singletonAnnotations;
    private Map<Class<?>, ScopeContext> contexts;
    private Set<Module> modules;
    private Set<ClassLoader> registeredClassLoaders;
    private Set<ImplementationFinder> implementationFinders;
    private Set<ImplementationClassProcessor> implementationClassProcessors;
    private Set<PostProcessor> postProcessors;
    protected final Module[] modulesForSetup;

    protected AbstractInjector(Module ... modules) {
        this.modulesForSetup = modules;
    }

    public Module[] getConfiguredModules() {
        return this.modulesForSetup;
    }

    protected void setup() {
        Module[] configuredModules = this.getConfiguredModules();
        this.modules = new HashSet<Module>();
        if (configuredModules != null && configuredModules.length > 0) {
            for (Module module : configuredModules) {
                this.modules.add(module);
            }
        }
        this.bindings = new HashMap();
        this.suppliers = new HashMap();
        this.singletonAnnotations = new LinkedHashSet<Class<? extends Annotation>>();
        this.valueSuppliers = new HashMap();
        this.contexts = new HashMap();
        this.suppliers.put(Injector.class, new Supplier<AbstractInjector>(this));
        this.registeredClassLoaders = new LinkedHashSet<ClassLoader>();
        this.implementationFinders = new LinkedHashSet<ImplementationFinder>();
        this.postProcessors = new LinkedHashSet<PostProcessor>();
        this.implementationClassProcessors = new LinkedHashSet<ImplementationClassProcessor>();
        if (configuredModules != null) {
            for (Module module : configuredModules) {
                module.configure();
                if (module.getClassLoaders() != null) {
                    this.registeredClassLoaders.addAll(module.getClassLoaders());
                }
                if (module.getBindings() != null) {
                    for (Class<?> clazz : module.getBindings().keySet()) {
                        Binding<?> binding = module.getBindings().get(clazz);
                        this.bindings.put(clazz, binding);
                    }
                }
                if (module.getScopes() != null) {
                    for (Class<?> clazz : module.getScopes().keySet()) {
                        ScopeContext context = module.getScopes().get(clazz);
                        this.contexts.put(clazz, context);
                    }
                }
                if (module.getSingletonScopes() != null) {
                    this.singletonAnnotations.addAll(module.getSingletonScopes());
                }
                if (module.getValueSuppliers() != null) {
                    for (Class clazz : module.getValueSuppliers().keySet()) {
                        ValueSupplier<?, ?> valueSupplier = module.getValueSuppliers().get(clazz);
                        this.valueSuppliers.put(clazz, valueSupplier);
                    }
                }
                if (module.getImplementationFinders() != null) {
                    for (ImplementationFinder implementationFinder : module.getImplementationFinders()) {
                        if (!(implementationFinder instanceof AbstractImplementationFinder) || this.reflectionHelper == null) continue;
                        ((AbstractImplementationFinder)implementationFinder).setReflectionHelper(this.reflectionHelper);
                    }
                    this.implementationFinders.addAll(module.getImplementationFinders());
                }
                if (module.getImplementationClassProcessors() != null) {
                    this.implementationClassProcessors.addAll(module.getImplementationClassProcessors());
                }
                if (module.getPostProcessors() == null) continue;
                this.postProcessors.addAll(module.getPostProcessors());
            }
        }
        this.createPreliminaryReflectionHelper();
        this.configureImplementationFinders();
    }

    protected void postSetup() {
        this.createFinalReflectionHelper();
        this.configureImplementationFinders();
    }

    protected void createPreliminaryReflectionHelper() {
        this.reflectionHelper = new ReflectionHelper();
    }

    protected void createFinalReflectionHelper() {
        this.reflectionHelper = this.getInstance(ReflectionHelper.class);
    }

    protected void configureImplementationFinders() {
        if (this.implementationFinders != null) {
            for (ImplementationFinder implementationFinder : this.implementationFinders) {
                if (!(implementationFinder instanceof AbstractImplementationFinder)) continue;
                ((AbstractImplementationFinder)implementationFinder).setReflectionHelper(this.reflectionHelper);
            }
        }
    }

    @Override
    public void injectMembers(Object instance) {
        if (instance != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            InjectionContext ctx = new InjectionContext();
            this.injectMembers(instance, instance.getClass(), ctx);
            this.postProcess(ctx);
        }
    }

    protected void postProcess(InjectionContext ctx) {
        if (ctx.createdInstances != null && this.postProcessors != null) {
            for (PostProcessor postProcessor : this.postProcessors) {
                this.postProcess(postProcessor, ctx.createdInstances);
            }
        }
    }

    public void postProcess(PostProcessor postProcessor, Map<Object, Set<Object>> createdInstances) {
        for (Map.Entry<Object, Set<Object>> entry : createdInstances.entrySet()) {
            postProcessor.process(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isInjected(AccessibleObject field) {
        javax.inject.Inject injectAnnotation = field.getAnnotation(javax.inject.Inject.class);
        if (injectAnnotation != null) {
            return true;
        }
        Inject jakartaInjectAnnotation = field.getAnnotation(Inject.class);
        if (jakartaInjectAnnotation != null) {
            return true;
        }
        if (!this.valueSuppliers.isEmpty()) {
            for (Class<? extends Annotation> valueSupplierClass : this.valueSuppliers.keySet()) {
                Annotation valueSupplierAnnotation = field.getAnnotation(valueSupplierClass);
                if (valueSupplierAnnotation == null) continue;
                return true;
            }
        }
        return false;
    }

    protected void injectMembers(Object instance, Class<?> classWithMembers, InjectionContext ctx) {
        for (Field field : this.reflectionHelper.getAllFields(classWithMembers)) {
            if (!this.isInjected(field)) continue;
            try {
                field.setAccessible(true);
                Class fieldClass = field.getType();
                boolean isProvider = false;
                if (javax.inject.Provider.class == fieldClass || Provider.class == fieldClass) {
                    ParameterizedType parameterizedType;
                    Type typeArgument;
                    isProvider = true;
                    Type genericType = field.getGenericType();
                    if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                        fieldClass = (Class)typeArgument;
                    }
                }
                Object injectedObject = this.get(fieldClass, isProvider, field, ctx);
                ctx.putInjectedObject(instance, injectedObject);
                field.set(instance, injectedObject);
            }
            catch (Exception e) {
                throw new GenesisException("Can not inject field '" + field.getName() + "' of class '" + instance.getClass().getCanonicalName() + "'", (Throwable)e);
            }
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(classWithMembers);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method setter = pd.getWriteMethod();
                if (setter == null) continue;
                setter.setAccessible(true);
                if (!this.isInjected(setter)) continue;
                Parameter parameter = setter.getParameters()[0];
                Class parameterClass = setter.getParameterTypes()[0];
                boolean isProvider = false;
                if (javax.inject.Provider.class == parameterClass || Provider.class == parameterClass) {
                    ParameterizedType parameterizedType;
                    Type typeArgument;
                    isProvider = true;
                    Type genericType = setter.getGenericParameterTypes()[0];
                    if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                        parameterClass = (Class)typeArgument;
                    }
                }
                Object injectedObject = this.get(parameterClass, isProvider, parameter, ctx);
                ctx.putInjectedObject(instance, injectedObject);
                setter.invoke(instance, injectedObject);
            }
        }
        catch (Exception e) {
            throw new GenesisException("Can not inject setter of class '" + instance.getClass().getCanonicalName() + "'", (Throwable)e);
        }
    }

    @Override
    public <T> T getInstance(Class<T> instanceClass) {
        if (instanceClass != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            InjectionContext ctx = new InjectionContext();
            T t = this.get(instanceClass, false, null, ctx);
            this.postProcess(ctx);
            return t;
        }
        return null;
    }

    @Override
    public <T> Class<? extends T> getImplementationClass(String className) {
        Class<T> injectedClass = this.loadClass(className);
        return this.getImplementationClass(injectedClass);
    }

    public <T> Class<? extends T> loadClass(String className) {
        if (className != null) {
            if (this.modules == null) {
                this.setup();
                this.postSetup();
            }
            Class injectedClass = null;
            for (ClassLoader classLoader : this.registeredClassLoaders) {
                try {
                    injectedClass = this.reflectionHelper.load(classLoader, className);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return injectedClass;
        }
        return null;
    }

    @Override
    public <T> T getInstance(String className) {
        if (className != null) {
            Class<T> injectedClass = this.loadClass(className);
            if (injectedClass != null) {
                return this.getInstance(injectedClass);
            }
            throw new GenesisException("Class not found '" + className + "'");
        }
        return null;
    }

    protected Annotation getQualifierAnnotation(AnnotatedElement annotatedElement) {
        for (Annotation elementAnnotation : annotatedElement.getAnnotations()) {
            Class<? extends Annotation> annotationType = elementAnnotation.annotationType();
            if (annotationType.isAnnotationPresent(javax.inject.Qualifier.class)) {
                return elementAnnotation;
            }
            if (!annotationType.isAnnotationPresent(Qualifier.class)) continue;
            return elementAnnotation;
        }
        return null;
    }

    protected <T> T get(Class<T> instanceClass, boolean isProvider, AnnotatedElement annotatedElement, InjectionContext ctx) {
        Parameter parameter;
        Annotation annotation = null;
        if (annotatedElement != null && (annotation = this.getNameAnnotation(annotatedElement)) == null && (annotation = this.getQualifierAnnotation(annotatedElement)) == null && annotatedElement instanceof Parameter && (parameter = (Parameter)annotatedElement).getDeclaringExecutable() != null) {
            annotation = this.getQualifierAnnotation(parameter.getDeclaringExecutable());
        }
        if (ctx.creationStack.contains(instanceClass)) {
            throw new GenesisException("Circular dependency detected during creation of '" + instanceClass + "', stack = " + ctx.creationStack.toString());
        }
        Supplier<Object> supplier = this.suppliers.get(instanceClass);
        if (supplier == null) {
            Binding<?> binding = this.bindings.get(instanceClass);
            if (binding != null) {
                supplier = new Supplier(instanceClass, binding.implementationClass, binding.getInstance(), this, binding.getScope());
                supplier.setImplementationClassProcessors(this.implementationClassProcessors);
                if (binding.nameBindings != null) {
                    supplier.annotationProviders = new HashMap();
                    for (String string : binding.nameBindings.keySet()) {
                        Binding annotationBinding = binding.nameBindings.get(string);
                        supplier.annotationProviders.put(string, new Supplier(instanceClass, annotationBinding.implementationClass, annotationBinding.getInstance(), this, annotationBinding.getScope()));
                    }
                }
                if (binding.annotationClassBindings != null) {
                    supplier.annotationClassProviders = new HashMap();
                    for (Class clazz : binding.annotationClassBindings.keySet()) {
                        Binding annotationClassBinding = binding.annotationClassBindings.get(clazz);
                        supplier.annotationClassProviders.put(clazz, new Supplier(instanceClass, annotationClassBinding.implementationClass, annotationClassBinding.getInstance(), this, annotationClassBinding.getScope()));
                    }
                }
            } else {
                supplier = new Supplier<Object>(instanceClass, null, null, this, null);
                supplier.setImplementationClassProcessors(this.implementationClassProcessors);
            }
            this.suppliers.put(instanceClass, supplier);
        }
        if (isProvider) {
            final Supplier<?> finalProvider = supplier;
            final Annotation finalAnnotation = annotation;
            final InjectionContext injectionContext = ctx;
            return (T)new javax.inject.Provider<T>(){

                public T get() {
                    if (!injectionContext.creationStack.isEmpty()) {
                        throw new GenesisException("Provider 'get()' invoked before parent injection finished (probably in a constructor).");
                    }
                    InjectionContext ctx = new InjectionContext();
                    Object t = finalProvider.getInstance(AbstractInjector.this, finalAnnotation, ctx);
                    AbstractInjector.this.postProcess(ctx);
                    return t;
                }
            };
        }
        return (T)supplier.getInstance(this, annotation, ctx);
    }

    @Override
    public <T> Class<? extends T> getImplementationClass(Class<T> injectedClass) {
        Class<T> implementationClass = null;
        for (ClassLoader classLoader : this.registeredClassLoaders) {
            for (ImplementationFinder implementationFinder : this.implementationFinders) {
                Class<T> implementationClassFromModule = implementationFinder.find(classLoader, injectedClass);
                if (implementationClassFromModule == null) continue;
                implementationClass = implementationClassFromModule;
            }
        }
        if (implementationClass != null) {
            return implementationClass;
        }
        return injectedClass;
    }

    public ScopeContext getContext(Class<?> scope) {
        ScopeContext context = this.contexts.get(scope);
        if (context == null) {
            throw new GenesisException("No context defined for scope '" + scope.getCanonicalName() + "'");
        }
        return context;
    }

    protected <T extends Annotation> ValueSupplier<T, ?> getValueSupplier(Class<T> annotation) {
        return this.valueSuppliers.get(annotation);
    }

    protected boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        if (annotationType.isAnnotationPresent(javax.inject.Scope.class)) {
            return true;
        }
        if (annotationType.isAnnotationPresent(Scope.class)) {
            return true;
        }
        for (Class<? extends Annotation> singletonAnnotation : this.singletonAnnotations) {
            if (!annotationType.equals(singletonAnnotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSingleton(Class<? extends Annotation> scopeAnnotationType) {
        if (javax.inject.Singleton.class.equals(scopeAnnotationType)) {
            return true;
        }
        if (Singleton.class.equals(scopeAnnotationType)) {
            return true;
        }
        return this.singletonAnnotations.contains(scopeAnnotationType);
    }

    protected Annotation getNameAnnotation(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(javax.inject.Named.class)) {
            return annotatedElement.getAnnotation(javax.inject.Named.class);
        }
        if (annotatedElement.isAnnotationPresent(Named.class)) {
            return annotatedElement.getAnnotation(Named.class);
        }
        return null;
    }
}

