/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.iworkz.genesis.Injector;
import org.iworkz.genesis.InjectorFactory;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.impl.AbstractInjector;
import org.iworkz.genesis.impl.AbstractModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractInjectorFactory
implements InjectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInjectorFactory.class);
    protected final List<Module> registeredModules = new ArrayList<Module>();
    private Injector instance;
    private boolean bulkRegistration = false;

    public AbstractInjectorFactory() {
        this.registerModule(new AbstractModule(){});
    }

    @Override
    public void registerModules(Module ... modules) {
        if (modules != null) {
            this.bulkRegistration = true;
            for (Module module : modules) {
                this.registerModule(module);
            }
            this.bulkRegistration = false;
        }
        this.updateInjector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModule(Module module) {
        List<Module> list = this.registeredModules;
        synchronized (list) {
            logger.debug("register module: {}", (Object)module.getClass().getCanonicalName());
            this.registeredModules.add(module);
            if (!this.bulkRegistration) {
                this.updateInjector();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModule(Module module) {
        List<Module> list = this.registeredModules;
        synchronized (list) {
            logger.debug("unregister module: {}", (Object)module.getClass().getCanonicalName());
            this.registeredModules.remove(module);
            this.updateInjector();
        }
    }

    @Override
    public Injector getInjector() {
        if (this.instance == null) {
            this.instance = new AbstractInjector(new Module[0]){

                @Override
                public Module[] getConfiguredModules() {
                    return AbstractInjectorFactory.this.getConfiguredModules();
                }
            };
        }
        return this.instance;
    }

    protected void updateInjector() {
        logger.debug("updateInjector");
        this.instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module[] getConfiguredModules() {
        List<Module> list = this.registeredModules;
        synchronized (list) {
            List<Module> allModules = this.allModules();
            List<Module> filteredModules = this.filterModules(allModules);
            this.sortModules(filteredModules);
            for (Module filteredModule : filteredModules) {
                logger.debug("filtered module: {} (ranking={})", (Object)filteredModule.getClass().getCanonicalName(), (Object)filteredModule.getRanking());
            }
            return filteredModules.toArray(new Module[filteredModules.size()]);
        }
    }

    protected List<Module> allModules() {
        HashSet<Module> additionalDependencies = new HashSet<Module>();
        for (Module module : this.registeredModules) {
            if (module.getDependencies() == null) continue;
            for (Module dependencyModule : module.getDependencies()) {
                boolean isExtendedByAnotherModule = false;
                for (Module aModule : this.registeredModules) {
                    if (!dependencyModule.getClass().isInstance(aModule)) continue;
                    isExtendedByAnotherModule = true;
                    break;
                }
                if (isExtendedByAnotherModule) continue;
                additionalDependencies.add(dependencyModule);
            }
        }
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(additionalDependencies);
        allModules.addAll(this.registeredModules);
        return allModules;
    }

    protected List<Module> filterModules(List<Module> modules) {
        ArrayList<Module> filteredModules = new ArrayList<Module>();
        for (Module module : modules) {
            boolean isExtendedByAnotherModule = false;
            for (Module anotherModule : modules) {
                if (module == anotherModule || !module.getClass().isInstance(anotherModule)) continue;
                isExtendedByAnotherModule = true;
                break;
            }
            if (isExtendedByAnotherModule) continue;
            filteredModules.add(module);
        }
        return filteredModules;
    }

    protected void sortModules(List<Module> modules) {
        Collections.sort(modules, new Comparator<Module>(){

            @Override
            public int compare(Module m1, Module m2) {
                if (m1.getRanking() < m2.getRanking()) {
                    return -1;
                }
                if (m1.getRanking() > m2.getRanking()) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

