/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import org.iworkz.common.exception.GenesisException;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.genesis.ImplementationClassProcessor;
import org.iworkz.genesis.Injector;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.PostProcessor;
import org.iworkz.genesis.ValueSupplier;
import org.iworkz.genesis.impl.AbstractImplementationFinder;
import org.iworkz.genesis.impl.Binding;
import org.iworkz.genesis.impl.ImplementationFinder;
import org.iworkz.genesis.impl.InjectionContext;
import org.iworkz.genesis.impl.scope.ScopeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule
implements Module {
    private static final Logger logger = LoggerFactory.getLogger(AbstractModule.class);
    private static Map<Class<? extends Module>, Module> moduleInstanceMap = new IdentityHashMap<Class<? extends Module>, Module>();
    private Map<Class<?>, Binding<?>> bindings;
    private Map<Class<?>, ScopeContext> scopes;
    private List<Class<? extends Annotation>> singletonAnnotations;
    private Map<Class<? extends Annotation>, ValueSupplier<?, ?>> valueSuppliers;
    private Set<ClassLoader> registeredClassLoaders;
    private Set<ImplementationFinder> implementationFinders;
    private Set<PostProcessor> postProcessors;
    private Set<ImplementationClassProcessor> implementationClassProcessors;
    private int ranking;
    protected final Set<Module> dependencies = new HashSet<Module>();
    private final ImplementationFinder standardImplementationFinder = new AbstractImplementationFinder(){

        @Override
        public <T> Class<? extends T> find(ClassLoader classLoader, Class<T> injectedClass) {
            Class foundClass = null;
            if (injectedClass.isInterface()) {
                foundClass = this.reflectionHelper.findClassWithPostfix(classLoader, injectedClass, "impl", "Impl");
            }
            return foundClass;
        }
    };
    private final PostProcessor standardPostProcessor = new PostProcessor(){
        ReflectionHelper reflectionHelper = new ReflectionHelper();

        @Override
        public void process(Object createdInstance, Set<Object> injectedObjects) {
            Method postConstructMethod = this.reflectionHelper.findFirstDeclaredMethod(createdInstance.getClass(), (Predicate)new Predicate<Method>(){

                @Override
                public boolean test(Method method) {
                    jakarta.annotation.PostConstruct jakartaPostConstructAnnotation = method.getAnnotation(jakarta.annotation.PostConstruct.class);
                    PostConstruct javaxPostConstructAnnotation = method.getAnnotation(PostConstruct.class);
                    return jakartaPostConstructAnnotation != null || javaxPostConstructAnnotation != null;
                }
            });
            if (postConstructMethod != null) {
                try {
                    postConstructMethod.setAccessible(true);
                    postConstructMethod.invoke(createdInstance, new Object[0]);
                }
                catch (Exception e) {
                    throw new GenesisException("Invocation of post construct method '" + postConstructMethod.getName() + "' failed (class='" + createdInstance + ")", (Throwable)e);
                }
            }
        }
    };
    private final ImplementationClassProcessor standardImplementationClassProcessor = new ImplementationClassProcessor(){

        @Override
        public Class process(Class implementationClass, Injector injector, InjectionContext ctx) {
            return implementationClass;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends Module> T getInstance(Class<T> moduleClass) {
        Map<Class<? extends Module>, Module> map = moduleInstanceMap;
        synchronized (map) {
            Module t = moduleInstanceMap.get(moduleClass);
            if (t == null) {
                try {
                    t = (Module)moduleClass.newInstance();
                }
                catch (Exception e) {
                    throw new GenesisException("Module instance can not be created", (Throwable)e);
                }
                moduleInstanceMap.put(moduleClass, t);
            }
            return (T)t;
        }
    }

    @Override
    public void configure() {
        Class<?> moduleClass = this.getClass();
        while (moduleClass != null) {
            this.registerClassLoader(moduleClass.getClassLoader());
            Class<?> superClass = moduleClass.getSuperclass();
            if (Module.class.isAssignableFrom(superClass)) {
                moduleClass = superClass;
                continue;
            }
            moduleClass = null;
        }
        this.registerImplementationClassProcessor(this.getStandardImplementationClassProcessor());
        this.registerImplementationFinder(this.getStandardImplementationFinder());
        this.registerPostProcessor(this.getStandardPostProcessor());
    }

    protected ImplementationFinder getStandardImplementationFinder() {
        return this.standardImplementationFinder;
    }

    protected PostProcessor getStandardPostProcessor() {
        return this.standardPostProcessor;
    }

    protected ImplementationClassProcessor getStandardImplementationClassProcessor() {
        return this.standardImplementationClassProcessor;
    }

    protected void registerImplementationFinder(ImplementationFinder implementationFinder) {
        if (this.implementationFinders == null) {
            this.implementationFinders = new LinkedHashSet<ImplementationFinder>();
        }
        this.implementationFinders.add(implementationFinder);
    }

    protected void registerImplementationClassProcessor(ImplementationClassProcessor implementationClassProcessor) {
        if (this.implementationClassProcessors == null) {
            this.implementationClassProcessors = new LinkedHashSet<ImplementationClassProcessor>();
        }
        this.implementationClassProcessors.add(implementationClassProcessor);
    }

    @Override
    public Set<ImplementationClassProcessor> getImplementationClassProcessors() {
        return this.implementationClassProcessors;
    }

    @Override
    public Set<ImplementationFinder> getImplementationFinders() {
        return this.implementationFinders;
    }

    protected void addDependency(Module moduleClass) {
        this.dependencies.add(moduleClass);
    }

    @Override
    public Set<Module> getDependencies() {
        return this.dependencies;
    }

    protected <T> Binding<T> bind(Class<T> singletonClass) {
        Binding<Object> binding;
        if (this.bindings == null) {
            this.bindings = new HashMap();
        }
        if ((binding = this.bindings.get(singletonClass)) == null) {
            binding = new Binding<T>(singletonClass);
            this.bindings.put(singletonClass, binding);
        }
        return binding;
    }

    protected void bindScope(Class<?> scopeAnnotationClass, ScopeContext scopeClass) {
        if (this.scopes == null) {
            this.scopes = new HashMap();
        }
        this.scopes.put(scopeAnnotationClass, scopeClass);
    }

    protected void bindSingletonScope(Class<? extends Annotation> singletonAnnotationClass) {
        if (this.singletonAnnotations == null) {
            this.singletonAnnotations = new ArrayList<Class<? extends Annotation>>();
        }
        this.singletonAnnotations.add(singletonAnnotationClass);
    }

    protected void bindValueSupplier(Class<? extends Annotation> supplierAnnotationClass, ValueSupplier<?, ?> valueSupplier) {
        if (this.valueSuppliers == null) {
            this.valueSuppliers = new HashMap();
        }
        this.valueSuppliers.put(supplierAnnotationClass, valueSupplier);
    }

    @Override
    public Map<Class<?>, Binding<?>> getBindings() {
        return this.bindings;
    }

    @Override
    public Map<Class<? extends Annotation>, ValueSupplier<?, ?>> getValueSuppliers() {
        return this.valueSuppliers;
    }

    @Override
    public List<Class<? extends Annotation>> getSingletonScopes() {
        return this.singletonAnnotations;
    }

    protected void registerClassLoader(ClassLoader classLoader) {
        if (this.registeredClassLoaders == null) {
            this.registeredClassLoaders = new HashSet<ClassLoader>();
        }
        this.registeredClassLoaders.add(classLoader);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        return this.registeredClassLoaders;
    }

    protected void registerPostProcessor(PostProcessor postProcessor) {
        if (this.postProcessors == null) {
            this.postProcessors = new HashSet<PostProcessor>();
        }
        this.postProcessors.add(postProcessor);
    }

    @Override
    public Set<PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    protected void postProcess(Object instance, Set<Object> injectedObjects) {
    }

    @Override
    public Map<Class<?>, ScopeContext> getScopes() {
        return this.scopes;
    }
}

