/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class Binding<T> {
    protected final Class<T> singletonClass;
    protected Class<? extends T> implementationClass;
    protected T instance;
    protected Class<? extends Annotation> scope;
    protected Map<String, Binding<T>> nameBindings;
    protected Map<Class<? extends Annotation>, Binding<T>> annotationClassBindings;

    public Binding(Class<T> singletonClass) {
        this.singletonClass = singletonClass;
    }

    public Binding<T> annotatedWith(String name) {
        return this.annotatedWithName(name);
    }

    public Binding<T> annotatedWithName(String name) {
        Binding<T> annotationBinding;
        if (this.nameBindings == null) {
            this.nameBindings = new HashMap<String, Binding<T>>();
        }
        if ((annotationBinding = this.nameBindings.get(name)) == null) {
            annotationBinding = new Binding<T>(this.singletonClass);
            this.nameBindings.put(name, annotationBinding);
        }
        return annotationBinding;
    }

    public Binding<T> annotatedWith(Class<? extends Annotation> annotationClass) {
        Binding<T> annotationClassBinding;
        if (this.annotationClassBindings == null) {
            this.annotationClassBindings = new HashMap<Class<? extends Annotation>, Binding<T>>();
        }
        if ((annotationClassBinding = this.annotationClassBindings.get(annotationClass)) == null) {
            annotationClassBinding = new Binding<T>(this.singletonClass);
            this.annotationClassBindings.put(annotationClass, annotationClassBinding);
        }
        return annotationClassBinding;
    }

    public Binding<T> to(Class<? extends T> implementationClass) {
        this.implementationClass = implementationClass;
        this.instance = null;
        return this;
    }

    public void toInstance(T instance) {
        this.instance = instance;
        this.implementationClass = null;
    }

    public T getInstance() {
        return this.instance;
    }

    public void in(Class<? extends Annotation> scopeAnnotationClass) {
        this.scope = scopeAnnotationClass;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }
}

