/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import org.iworkz.genesis.Injector;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectedServiceFactory<T>
implements ServiceFactory<T> {
    private static final Logger logger = LoggerFactory.getLogger(InjectedServiceFactory.class);
    private T instance;
    protected final Injector injector;
    protected final Class<T> serviceClass;

    public InjectedServiceFactory(Injector injector, Class<T> serviceClass) {
        logger.debug("create injected service factory for '{}'", (Object)serviceClass.getCanonicalName());
        this.injector = injector;
        this.serviceClass = serviceClass;
    }

    public T getService(Bundle bundle, ServiceRegistration<T> registration) {
        if (this.instance == null) {
            this.instance = this.injector.getInstance(this.serviceClass);
            logger.debug("get injected service '{}'", (Object)this.instance.getClass().getCanonicalName());
        }
        return this.instance;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<T> registration, T service) {
    }
}

