/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.iworkz.common.exception.GenesisException;
import org.iworkz.genesis.ImplementationClassProcessor;
import org.iworkz.genesis.ValueSupplier;
import org.iworkz.genesis.impl.AbstractInjector;
import org.iworkz.genesis.impl.InjectionContext;
import org.iworkz.genesis.impl.scope.NoScope;
import org.iworkz.genesis.impl.scope.ScopeContext;

public class Supplier<T> {
    protected final Class<T> injectedClass;
    protected Class<? extends T> implementationClass;
    protected boolean implementationClassPrepared;
    protected boolean singleton;
    protected Class<? extends Annotation> scope;
    protected T instance;
    protected AbstractInjector injector;
    protected Map<String, Supplier<T>> annotationProviders;
    protected Map<Class<? extends Annotation>, Supplier<T>> annotationClassProviders;
    private Set<ImplementationClassProcessor> implementationClassProcessors;

    public Supplier(T instance) {
        this(instance.getClass(), instance.getClass(), instance, null, null);
    }

    public Supplier(Supplier<T> supplier, boolean scoped) {
        this.injector = supplier.injector;
        this.injectedClass = supplier.injectedClass;
        this.instance = supplier.instance;
        this.implementationClass = supplier.implementationClass;
        if (scoped) {
            this.singleton = true;
        } else {
            this.singleton = supplier.singleton;
            this.scope = supplier.scope;
        }
    }

    public Supplier(Class<T> injectedClass, Class<? extends T> implementationClass, T instance, AbstractInjector injector, Class<? extends Annotation> scope) {
        this.injector = injector;
        this.injectedClass = injectedClass;
        this.instance = instance;
        this.implementationClass = instance != null ? instance.getClass() : (implementationClass != null ? implementationClass : injector.getImplementationClass(injectedClass));
        if (scope != null) {
            if (scope != NoScope.class) {
                this.scope = scope;
            }
        } else if (this.implementationClass != null) {
            this.scope = this.getScopeAnnotationType(this.implementationClass);
        }
        if (this.scope != null) {
            this.singleton = injector.isSingleton(this.scope);
        }
    }

    private Class<? extends Annotation> getScopeAnnotationType(Class<? extends T> implementationClass) {
        for (Annotation classAnnotation : implementationClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = classAnnotation.annotationType();
            if (!this.injector.isScopeAnnotation(annotationType)) continue;
            return annotationType;
        }
        return null;
    }

    public Object getInstance(AbstractInjector injector, Annotation annotation, InjectionContext ctx) {
        if (annotation != null) {
            Supplier<T> annotationClassProvider;
            Supplier<T> annotationProvider;
            String name;
            if (this.annotationProviders != null && (name = this.getAnnotatedName(annotation)) != null && (annotationProvider = this.annotationProviders.get(name)) != null) {
                return annotationProvider.getInstance(injector, null, ctx);
            }
            if (this.annotationClassProviders != null && (annotationClassProvider = this.annotationClassProviders.get(annotation.annotationType())) != null) {
                return annotationClassProvider.getInstance(injector, null, ctx);
            }
            Object value = this.getValueFromSupplier(annotation);
            if (value != null) {
                return value;
            }
            throw new GenesisException("No binding found for annotation " + annotation.annotationType().getCanonicalName() + " (injected class: " + this.injectedClass.getCanonicalName() + " )");
        }
        if (this.scope != null && !this.singleton && this.injectedClass != null) {
            ScopeContext scopeContext = injector.getContext(this.scope);
            Supplier<T> scopedSupplier = scopeContext.get(this.injectedClass, this, this.implementationClassProcessors);
            return scopedSupplier.getInstance(injector, null, ctx);
        }
        if (this.instance != null) {
            return this.instance;
        }
        this.prepareImplementationClass(ctx);
        ctx.creationStack.push(this.injectedClass);
        T newInstance = this.createInstance(injector, ctx);
        if (this.singleton) {
            this.instance = newInstance;
        }
        ctx.creationStack.pop();
        injector.injectMembers(newInstance, newInstance.getClass(), ctx);
        return newInstance;
    }

    protected String getAnnotatedName(Annotation annotation) {
        if (annotation instanceof Named) {
            Named jakartaNamed = (Named)annotation;
            return jakartaNamed.value();
        }
        if (annotation instanceof javax.inject.Named) {
            javax.inject.Named javaxNamed = (javax.inject.Named)annotation;
            return javaxNamed.value();
        }
        return null;
    }

    protected <A extends Annotation> Object getValueFromSupplier(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ValueSupplier<Annotation, ? extends Annotation> valueSupplier = this.injector.getValueSupplier(annotationType);
        if (valueSupplier != null) {
            return valueSupplier.getValue(annotation, this.scope);
        }
        return null;
    }

    protected void prepareImplementationClass(InjectionContext ctx) {
        if (!this.implementationClassPrepared) {
            if (this.implementationClass == null) {
                this.implementationClass = this.injectedClass;
            }
            if (this.implementationClassProcessors != null) {
                for (ImplementationClassProcessor implementationClassProcessor : this.implementationClassProcessors) {
                    this.implementationClass = implementationClassProcessor.process(this.implementationClass, this.injector, ctx);
                }
            }
            this.implementationClassPrepared = true;
        }
    }

    protected T createInstance(AbstractInjector injector, InjectionContext ctx) {
        try {
            Constructor<T> constructor = this.getConstructor(this.implementationClass);
            if (constructor != null) {
                constructor.setAccessible(true);
                if (constructor.getParameterCount() > 0) {
                    Parameter[] parameters = constructor.getParameters();
                    Type[] genericParameterTypes = constructor.getGenericParameterTypes();
                    Object[] initargs = new Object[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        Parameter parameter = parameters[i];
                        Class parameterClass = parameter.getType();
                        boolean isProvider = false;
                        if (javax.inject.Provider.class == parameterClass || Provider.class == parameterClass) {
                            ParameterizedType parameterizedType;
                            Type typeArgument;
                            isProvider = true;
                            Type genericType = genericParameterTypes[i];
                            if (genericType instanceof ParameterizedType && (typeArgument = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                                parameterClass = (Class)typeArgument;
                            }
                        }
                        Object parameterValue = injector.get(parameterClass, isProvider, parameter, ctx);
                        initargs[i] = isProvider ? parameterValue : this.convertParameter(parameterClass, parameterValue);
                    }
                    T t = constructor.newInstance(initargs);
                    ctx.putInjectedObjects(t, initargs);
                    return t;
                }
                T t = constructor.newInstance(new Object[0]);
                ctx.createdInstances.put(t, null);
                return t;
            }
            throw new GenesisException("No suitable constructor found for injection of class: " + this.implementationClass.getCanonicalName());
        }
        catch (Exception e) {
            throw new GenesisException("Can not create singleton for class '" + this.implementationClass.getCanonicalName() + "'", (Throwable)e);
        }
    }

    protected Object convertParameter(Class<?> parameterClass, Object parameterValue) {
        if (parameterValue == null) {
            return null;
        }
        Class<?> classOfParameterValue = parameterValue.getClass();
        if (!parameterClass.isAssignableFrom(classOfParameterValue)) {
            if (parameterValue instanceof String) {
                if (parameterClass.equals(Integer.class)) {
                    return Integer.parseInt((String)parameterValue);
                }
                if (parameterClass.equals(Long.class)) {
                    return Long.parseLong((String)parameterValue);
                }
                if (parameterClass.equals(Boolean.class)) {
                    return Boolean.parseBoolean((String)parameterValue);
                }
            }
            throw new GenesisException("Failed to convert parameter of type " + classOfParameterValue.getCanonicalName() + " to " + parameterClass.getCanonicalName());
        }
        return parameterValue;
    }

    public Constructor<? extends T> getConstructor(Class<? extends T> implementationClass) {
        Constructor<?> matchingConstructor = null;
        for (Constructor<?> c : implementationClass.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(javax.inject.Inject.class)) {
                return c;
            }
            if (c.isAnnotationPresent(Inject.class)) {
                return c;
            }
            if (c.getParameterCount() != 0) continue;
            matchingConstructor = c;
        }
        if (matchingConstructor == null && implementationClass.isInterface()) {
            throw new GenesisException("Can not create singleton of interface '" + implementationClass.getCanonicalName() + "'");
        }
        return matchingConstructor;
    }

    public void setImplementationClassProcessors(Set<ImplementationClassProcessor> implementationClassProcessors) {
        this.implementationClassProcessors = implementationClassProcessors;
    }
}

