package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;


@Singleton
public class ContextAccess {
	
	private final ThreadLocal<Context> context = new ThreadLocal<Context>() {	
	    @Override 
	    protected Context initialValue() {
	    		return createContext();
	    }
	};
	
	@Inject
	protected DataSourceProvider dataSourceProvider;
	
	public Context getContext() {
		return context.get();
	}
	
	public void startContext() {
		getContext().start();
	}
	
	public void closeContext() {
		try {
			getContext().close();
		} finally {
			context.remove();
		}
	}
	
	protected Context createContext() {
		Context ctx = new Context(dataSourceProvider.getDataSource());
        return ctx;
	}

//	/**
//	 * Intended to be used in standalone mode when the dataSourceProvider is
//	 * not injected.
//	 * 
//	 * @param dataSource
//	 */
//	protected void setDataSource(final DataSource dataSource) {
//		this.dataSourceProvider = new AbstractDataSourceProvider(null) {
//			@Override
//			protected DataSource createDataSource(Object options) {
//				return dataSource;
//			}
//		};
//	}
//	
	protected DataSource getDataSource() {
		return dataSourceProvider.getDataSource();
	}

}
