package org.iworkz.habitat.dao;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.iworkz.habitat.entity.EntityDefinition;
import org.iworkz.habitat.entity.EntityDefinitionCreator;

@Singleton
abstract public class EntityDao {

    private EntityDefinition entityDefinition;

    @Inject
    protected EntityDefinitionCreator entityDefinitionCreator;

    public EntityDefinition getEntityDefinition() {
        if (this.entityDefinition == null) {
            createEntityDefinition();
        }
        return this.entityDefinition;
    }

    protected synchronized void createEntityDefinition() {
        if (this.entityDefinition == null) {
            this.entityDefinition = this.entityDefinitionCreator.readEntityDefinition(getClass());
        }
    }

}
