/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.iworkz.genesis.Module;
import org.iworkz.genesis.PostProcessor;
import org.iworkz.genesis.impl.AbstractImplementationFinder;
import org.iworkz.genesis.impl.Binding;
import org.iworkz.genesis.impl.ImplementationFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule
implements Module {
    private static final Logger logger = LoggerFactory.getLogger(AbstractModule.class);
    private static Map<Class<? extends Module>, Module> moduleInstanceMap = new IdentityHashMap<Class<? extends Module>, Module>();
    private Map<Class<?>, Binding<?>> bindings;
    private Set<ClassLoader> registeredClassLoaders;
    private Set<ImplementationFinder> implementationFinders;
    private Set<PostProcessor> postProcessors;
    private int ranking;
    protected final Set<Module> dependencies = new HashSet<Module>();
    private static final ImplementationFinder standardImplementationFinder = new AbstractImplementationFinder(){

        @Override
        public <T> Class<? extends T> find(ClassLoader classLoader, Class<T> injectedClass) {
            Class<T> foundClass = null;
            if (injectedClass.isInterface()) {
                foundClass = this.reflectionHelper.findClassWithPostfix(classLoader, injectedClass, "impl", "Impl");
            }
            return foundClass;
        }
    };
    private static final PostProcessor standardPostProcessor = new PostProcessor(){

        @Override
        public void process(Object createdInstance, Set<Object> injectedObjects) {
            for (Method method : createdInstance.getClass().getMethods()) {
                PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
                if (postConstructAnnotation == null) continue;
                try {
                    method.invoke(createdInstance, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invocation of post construct method '" + method.getName() + "' failed (class='" + createdInstance + ")", e);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends Module> T getInstance(Class<T> moduleClass) {
        Map<Class<? extends Module>, Module> map = moduleInstanceMap;
        synchronized (map) {
            Module t = moduleInstanceMap.get(moduleClass);
            if (t == null) {
                try {
                    t = (Module)moduleClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Module instance can not be created", e);
                }
                moduleInstanceMap.put(moduleClass, t);
            }
            return (T)t;
        }
    }

    @Override
    public void configure() {
        Class<?> moduleClass = this.getClass();
        while (moduleClass != null) {
            this.registerClassLoader(moduleClass.getClassLoader());
            Class<?> superClass = moduleClass.getSuperclass();
            if (Module.class.isAssignableFrom(superClass)) {
                moduleClass = superClass;
                continue;
            }
            moduleClass = null;
        }
        this.registerImplementationFinder(this.getStandardImplementationFinder());
        this.registerPostProcessor(this.getStandardPostProcessor());
    }

    protected ImplementationFinder getStandardImplementationFinder() {
        return standardImplementationFinder;
    }

    protected PostProcessor getStandardPostProcessor() {
        return standardPostProcessor;
    }

    protected void registerImplementationFinder(ImplementationFinder implementationFinder) {
        if (this.implementationFinders == null) {
            this.implementationFinders = new HashSet<ImplementationFinder>();
        }
        this.implementationFinders.add(implementationFinder);
    }

    @Override
    public Set<ImplementationFinder> getImplementationFinders() {
        return this.implementationFinders;
    }

    protected void addDependency(Module moduleClass) {
        this.dependencies.add(moduleClass);
    }

    @Override
    public Set<Module> getDependencies() {
        return this.dependencies;
    }

    protected <T> Binding<T> bind(Class<T> singletonClass) {
        Binding<Object> binding;
        if (this.bindings == null) {
            this.bindings = new HashMap();
        }
        if ((binding = this.bindings.get(singletonClass)) == null) {
            binding = new Binding<T>(singletonClass);
            this.bindings.put(singletonClass, binding);
        }
        return binding;
    }

    @Override
    public Map<Class<?>, Binding<?>> getBindings() {
        return this.bindings;
    }

    protected void registerClassLoader(ClassLoader classLoader) {
        if (this.registeredClassLoaders == null) {
            this.registeredClassLoaders = new HashSet<ClassLoader>();
        }
        this.registeredClassLoaders.add(classLoader);
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        return this.registeredClassLoaders;
    }

    protected void registerPostProcessor(PostProcessor postProcessor) {
        if (this.postProcessors == null) {
            this.postProcessors = new HashSet<PostProcessor>();
        }
        this.postProcessors.add(postProcessor);
    }

    @Override
    public Set<PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    protected void postProcess(Object instance, Set<Object> injectedObjects) {
    }
}

