/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.genesis.impl;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class InjectionContext {
    protected final Stack<Class<?>> creationStack = new Stack();
    protected final Map<Object, Set<Object>> createdInstances = new IdentityHashMap<Object, Set<Object>>();

    public void putInjectedObject(Object instance, Object injectedObject) {
        Set<Object> injectedObjects = this.createdInstances.get(instance);
        if (injectedObjects == null) {
            injectedObjects = new HashSet<Object>();
            this.createdInstances.put(instance, injectedObjects);
        }
        injectedObjects.add(injectedObject);
    }

    public void putInjectedObjects(Object instance, Object[] injectedObjectArray) {
        if (injectedObjectArray != null && injectedObjectArray.length > 0) {
            Set<Object> injectedObjects = this.createdInstances.get(instance);
            if (injectedObjects == null) {
                injectedObjects = new HashSet<Object>();
                this.createdInstances.put(instance, injectedObjects);
            }
            for (Object injectedObject : injectedObjectArray) {
                injectedObjects.add(injectedObject);
            }
        }
    }
}

