/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.dao;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Context {
    private boolean started;
    private Connection connection;
    private DataSource dataSource;

    public Context(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() {
        this.checkState();
        if (this.connection == null) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException("Can not get connection", e);
            }
        }
        return this.connection;
    }

    protected void checkState() {
        if (!this.started) {
            throw new IllegalStateException("The context has not been started.");
        }
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("The context is already started.");
        }
        this.started = true;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.connection = null;
            }
        }
        this.started = false;
    }
}

