/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.common.helper;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.iworkz.common.helper.ReflectionHelper;

@Singleton
public class CloneHelper {
    private static final Object PROPERTIES_CACHE_LOCK = new Object();
    private static final Map<Class<?>, PropertyInfo[]> PROPERTIES_CACHE = new IdentityHashMap();
    protected static final Set<Class<?>> FINAL_IMMUTABLES = new HashSet();
    @Inject
    protected ReflectionHelper reflectionHelper;

    public <T> T cloneBean(T source) {
        IdentityHashMap<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
        return this.cloneBean(source, instanceMap);
    }

    protected <T> T cloneBean(T source, Map<Object, Object> instanceMap) {
        if (source != null) {
            Object destination;
            if (instanceMap.containsKey(source)) {
                return (T)instanceMap.get(source);
            }
            Class<?> sourceClass = source.getClass();
            if (sourceClass.isArray()) {
                Class<?> componentType = sourceClass.getComponentType();
                boolean finalImmutuable = this.isImmutable(componentType);
                destination = this.cloneArray(source, componentType, finalImmutuable, instanceMap);
            } else {
                destination = Collection.class.isAssignableFrom(sourceClass) ? this.cloneCollection((Collection)source, instanceMap) : (Map.class.isAssignableFrom(sourceClass) ? this.cloneMap((Map)source, instanceMap) : (this.isCloneRequired(sourceClass) ? this.clone(source, instanceMap) : source));
            }
            return (T)destination;
        }
        return null;
    }

    protected <T> T clone(T source, Map<Object, Object> instanceMap) {
        T destination = this.createCustomClone(source, instanceMap);
        if (destination != null) {
            instanceMap.put(source, destination);
        } else {
            destination = this.createClone(source);
            instanceMap.put(source, destination);
            this.cloneProperties(source, destination, instanceMap);
        }
        return destination;
    }

    protected <T> T createClone(T source) {
        return (T)this.reflectionHelper.createObject(source.getClass());
    }

    protected <T> T createCustomClone(T source, Map<Object, Object> instanceMap) {
        java.util.Date destination = null;
        Class<?> sourceClass = source.getClass();
        if (java.util.Date.class.isAssignableFrom(sourceClass)) {
            destination = Date.class == sourceClass ? new Date(((Date)source).getTime()) : (java.util.Date.class == sourceClass ? new java.util.Date(((java.util.Date)source).getTime()) : (Time.class == sourceClass ? new Time(((Time)source).getTime()) : (Timestamp.class == sourceClass ? new Timestamp(((Timestamp)source).getTime()) : null)));
        }
        return (T)destination;
    }

    protected <T> void cloneProperties(T source, T destination, Map<Object, Object> instanceMap) {
        if (source != null) {
            if (destination == null) {
                throw new IllegalArgumentException("The destination bean is null");
            }
            try {
                PropertyInfo[] propertyInfos;
                for (PropertyInfo propertyInfo : propertyInfos = this.getPropertyInfos(source.getClass())) {
                    Object value = propertyInfo.readMethod.invoke(source, new Object[0]);
                    if (value == null) continue;
                    if (propertyInfo.immutable) {
                        propertyInfo.writeMethod.invoke(destination, value);
                        continue;
                    }
                    if (propertyInfo.map) {
                        propertyInfo.writeMethod.invoke(destination, this.cloneMap((Map)value, instanceMap));
                        continue;
                    }
                    if (propertyInfo.collection) {
                        propertyInfo.writeMethod.invoke(destination, this.cloneCollection((Collection)value, instanceMap));
                        continue;
                    }
                    if (propertyInfo.array) {
                        Class<?> componentType = value.getClass().getComponentType();
                        propertyInfo.writeMethod.invoke(destination, this.cloneArray(value, componentType, propertyInfo.componentImmutable, instanceMap));
                        continue;
                    }
                    propertyInfo.writeMethod.invoke(destination, this.cloneBean(value, instanceMap));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not clone bean '" + source.getClass().getCanonicalName() + "'", e);
            }
        }
    }

    protected <T> Collection<T> createCollection(Collection<T> sourceCollection) {
        return (Collection)this.reflectionHelper.createObject(sourceCollection.getClass());
    }

    protected <T, R> Map<T, R> createMap(Map<T, R> sourceMap) {
        return (Map)this.reflectionHelper.createObject(sourceMap.getClass());
    }

    protected boolean isCloneRequired(Class<?> sourceClass) {
        if (this.isImmutable(sourceClass)) {
            return false;
        }
        return !Closeable.class.isAssignableFrom(sourceClass);
    }

    protected boolean isImmutable(Class<?> valueClass) {
        if (valueClass.isPrimitive()) {
            return false;
        }
        if (valueClass.isEnum()) {
            return false;
        }
        return FINAL_IMMUTABLES.contains(valueClass);
    }

    protected Object cloneArray(Object source, Class<?> sourceClass, boolean finalImmutable, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(source)) {
            return instanceMap.get(source);
        }
        int length = Array.getLength(source);
        Object destination = Array.newInstance(sourceClass, length);
        instanceMap.put(source, destination);
        if (finalImmutable) {
            System.arraycopy(source, 0, destination, 0, length);
        } else {
            for (int i = 0; i < length; ++i) {
                Object component = Array.get(source, i);
                Array.set(destination, i, this.cloneBean(component, instanceMap));
            }
        }
        return destination;
    }

    protected <T> Collection<T> cloneCollection(Collection<T> collection, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(collection)) {
            return (Collection)instanceMap.get(collection);
        }
        Collection<T> destination = this.createCollection(collection);
        instanceMap.put(collection, destination);
        for (T sourceItem : collection) {
            destination.add(this.cloneBean(sourceItem, instanceMap));
        }
        return destination;
    }

    protected <T, R> Map<T, R> cloneMap(Map<T, R> map, Map<Object, Object> instanceMap) {
        if (instanceMap.containsKey(map)) {
            return (Map)instanceMap.get(map);
        }
        Map<T, R> destination = this.createMap(map);
        instanceMap.put(map, destination);
        for (T sourceKey : map.keySet()) {
            R sourceItem = map.get(sourceKey);
            destination.put(sourceKey, this.cloneBean(sourceItem, instanceMap));
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyInfo[] getPropertyInfos(Class<?> sourceClass) {
        PropertyInfo[] propertyInfos = PROPERTIES_CACHE.get(sourceClass);
        if (propertyInfos == null) {
            Object object = PROPERTIES_CACHE_LOCK;
            synchronized (object) {
                try {
                    propertyInfos = PROPERTIES_CACHE.get(sourceClass);
                    if (propertyInfos == null) {
                        PropertyDescriptor[] propertyDescriptors;
                        ArrayList<PropertyInfo> propertyInfoList = new ArrayList<PropertyInfo>();
                        BeanInfo beanInfo = Introspector.getBeanInfo(sourceClass);
                        for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                            Method writeMethod;
                            Method readMethod = pd.getReadMethod();
                            if (readMethod == null || (writeMethod = pd.getWriteMethod()) == null) continue;
                            Class<?> valueClass = pd.getPropertyType();
                            propertyInfoList.add(this.createPropertyInfo(valueClass, readMethod, writeMethod));
                        }
                        propertyInfos = propertyInfoList.toArray(new PropertyInfo[propertyInfoList.size()]);
                        PROPERTIES_CACHE.put(sourceClass, propertyInfos);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can not create property infos", ex);
                }
            }
        }
        return propertyInfos;
    }

    protected PropertyInfo createPropertyInfo(Class<?> valueClass, Method readMethod, Method writeMethod) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.readMethod = readMethod;
        propertyInfo.writeMethod = writeMethod;
        if (valueClass.isArray()) {
            propertyInfo.array = true;
            propertyInfo.componentImmutable = this.isImmutable(valueClass.getComponentType());
        } else if (Collection.class.isAssignableFrom(valueClass)) {
            propertyInfo.collection = true;
        } else if (Map.class.isAssignableFrom(valueClass)) {
            propertyInfo.map = true;
        } else if (this.isImmutable(valueClass)) {
            propertyInfo.immutable = this.isImmutable(valueClass);
        }
        return propertyInfo;
    }

    static {
        FINAL_IMMUTABLES.add(String.class);
        FINAL_IMMUTABLES.add(Boolean.class);
        FINAL_IMMUTABLES.add(Character.class);
        FINAL_IMMUTABLES.add(Byte.class);
        FINAL_IMMUTABLES.add(Short.class);
        FINAL_IMMUTABLES.add(Integer.class);
        FINAL_IMMUTABLES.add(Long.class);
        FINAL_IMMUTABLES.add(Float.class);
        FINAL_IMMUTABLES.add(Double.class);
        FINAL_IMMUTABLES.add(Locale.class);
        FINAL_IMMUTABLES.add(UUID.class);
        FINAL_IMMUTABLES.add(BigInteger.class);
        FINAL_IMMUTABLES.add(BigDecimal.class);
    }

    protected static class PropertyInfo {
        Method readMethod;
        Method writeMethod;
        boolean collection;
        boolean map;
        boolean array;
        boolean immutable;
        boolean componentImmutable;

        protected PropertyInfo() {
        }
    }
}

