/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.common.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class ReflectionHelper {
    public <T> Field[] getAllFields(Class<T> objectClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addAllFields(fields, objectClass);
        return fields.toArray(new Field[fields.size()]);
    }

    protected <T> void addAllFields(List<Field> fields, Class<T> objectClass) {
        fields.addAll(Arrays.asList(objectClass.getDeclaredFields()));
        if (objectClass.getSuperclass() != null) {
            this.addAllFields(fields, objectClass.getSuperclass());
        }
    }

    public <T> T createObject(Class<T> objectClass) {
        try {
            Constructor<T> defaultConstructor = objectClass.getConstructor(new Class[0]);
            T obj = defaultConstructor.newInstance(new Object[0]);
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not create instance for class '" + objectClass.getName() + "'", ex);
        }
    }

    public <T> Class<? extends T> findClassWithPostfix(ClassLoader classLoader, Class<T> type, String packagePostFix, String namePostFix) {
        String parentClassPart;
        String classPart;
        String packagePart;
        String className = type.getName();
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            packagePart = className.substring(0, lastDotIndex);
            classPart = className.substring(lastDotIndex + 1);
        } else {
            packagePart = null;
            classPart = className;
        }
        int lastDollarIndex = classPart.lastIndexOf(36);
        if (lastDollarIndex >= 0) {
            parentClassPart = classPart.substring(0, lastDollarIndex);
            classPart = classPart.substring(lastDollarIndex + 1);
        } else {
            parentClassPart = null;
        }
        String customPackage = null;
        if (packagePart != null && packagePart.length() > 0) {
            customPackage = packagePostFix != null ? packagePart + "." + packagePostFix : packagePart;
        } else if (packagePostFix != null) {
            customPackage = packagePostFix;
        }
        String customClass = null;
        customClass = namePostFix != null ? classPart + namePostFix : classPart;
        if (parentClassPart != null) {
            customClass = parentClassPart + "$" + customClass;
        }
        String customClassName = null;
        customClassName = customPackage != null ? customPackage + "." + customClass : customClass;
        try {
            return this.load(classLoader, customClassName);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not find class with postfix '" + customClassName + "'");
        }
        return null;
    }

    public <T> Class<T> load(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return classLoader.loadClass(className);
    }
}

