/*
 * Decompiled with CFR 0.152.
 */
package org.iworkz.habitat.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.iworkz.common.helper.ReflectionHelper;
import org.iworkz.habitat.dao.GenericDao;
import org.iworkz.habitat.entity.EntityFieldDefinition;
import org.iworkz.habitat.entity.FieldValueStrategy;
import org.iworkz.habitat.helper.StringHelper;

public class EntityDefinition {
    private final String name;
    private List<EntityFieldDefinition> fields = new ArrayList<EntityFieldDefinition>();
    private List<EntityFieldDefinition> primaryKeyFields = new ArrayList<EntityFieldDefinition>();
    private List<EntityFieldDefinition> versionFields = new ArrayList<EntityFieldDefinition>();
    protected StringHelper stringHelper = new StringHelper();
    protected ReflectionHelper reflectionHelper;

    public EntityDefinition(String name, ReflectionHelper reflectionHelper) {
        this.name = name;
        this.reflectionHelper = reflectionHelper;
    }

    public String getName() {
        return this.name;
    }

    public List<EntityFieldDefinition> getFields() {
        return this.fields;
    }

    public List<EntityFieldDefinition> getPrimaryKey() {
        return this.primaryKeyFields;
    }

    public List<EntityFieldDefinition> getVersion() {
        return this.versionFields;
    }

    public <T> void appendFieldAssigmentSql(StringBuilder sql, Class<T> objectClass, boolean supportOnlyEntityFields) {
        if (objectClass != null) {
            Field[] objectFields = this.reflectionHelper.getAllFields(objectClass);
            List<EntityFieldDefinition> fields = this.getFields();
            int count = 0;
            block0: for (int i = 0; i < fields.size(); ++i) {
                EntityFieldDefinition f = fields.get(i);
                for (int j = 0; j < objectFields.length; ++j) {
                    String columnName = this.columnNameForField(objectFields[j].getName(), supportOnlyEntityFields);
                    if (columnName == null || !columnName.equals(f.getName())) continue;
                    if (count > 0) {
                        sql.append(", ");
                    }
                    sql.append(f.getName() + " = ?");
                    ++count;
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < this.fields.size(); ++i) {
                EntityFieldDefinition f = this.fields.get(i);
                sql.append(f.getName() + " = ?");
                if (i == this.fields.size() - 1) continue;
                sql.append(", ");
            }
        }
    }

    public void appendAdditionalFieldAssigmentSql(StringBuilder sql, GenericDao.CommandCustomizer statementAdapter) {
        String[] columnNames = statementAdapter.customColumns();
        if (columnNames != null) {
            for (String cn : columnNames) {
                if (statementAdapter.customValue(cn) != null) continue;
                sql.append(", ");
                sql.append(cn + " = ?");
            }
        }
    }

    public <T> void appendFieldSql(StringBuilder sql, Class<T> objectClass, boolean supportOnlyEntityFields) {
        if (objectClass != null) {
            Field[] objectFields = this.reflectionHelper.getAllFields(objectClass);
            List<EntityFieldDefinition> fields = this.getFields();
            int count = 0;
            block0: for (int i = 0; i < fields.size(); ++i) {
                EntityFieldDefinition f = fields.get(i);
                for (int j = 0; j < objectFields.length; ++j) {
                    String columnName = this.columnNameForField(objectFields[j].getName(), supportOnlyEntityFields);
                    if (columnName == null || !columnName.equals(f.getName())) continue;
                    if (count > 0) {
                        sql.append(", ");
                    }
                    sql.append(f.getName());
                    ++count;
                    continue block0;
                }
            }
        } else {
            List<EntityFieldDefinition> fields = this.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                EntityFieldDefinition f = fields.get(i);
                sql.append(f.getName());
                if (i == fields.size() - 1) continue;
                sql.append(", ");
            }
        }
    }

    public void appendAdditionalColumns(StringBuilder sql, String[] columnNames) {
        if (columnNames != null) {
            for (String cn : columnNames) {
                sql.append(", ");
                sql.append(cn);
            }
        }
    }

    public void appendFieldDefinitionsSql(StringBuilder sql) {
        for (EntityFieldDefinition f : this.getFields()) {
            StringBuilder command = new StringBuilder();
            command.append(f.getName());
            command.append(" ");
            command.append(f.getTypeName());
            command.append(f.getConstraintsSql());
            if (f.getValueStrategy() == FieldValueStrategy.AUTO) {
                command.append(" auto_increment");
            }
            command.append(f.getNotNullSql());
            command.append(", ");
            sql.append(command.toString());
        }
    }

    public <T> void appendFieldQuestionmarksSql(StringBuilder sql, Class<T> objectClass, GenericDao.CommandCustomizer statementAdapter) {
        if (objectClass != null) {
            Field[] objectFields = this.reflectionHelper.getAllFields(objectClass);
            List<EntityFieldDefinition> fields = this.getFields();
            int count = 0;
            block0: for (int i = 0; i < fields.size(); ++i) {
                EntityFieldDefinition f = fields.get(i);
                for (int j = 0; j < objectFields.length; ++j) {
                    String columnName = this.columnNameForField(objectFields[j].getName(), false);
                    if (columnName == null || !columnName.equals(f.getName())) continue;
                    if (count > 0) {
                        sql.append(", ");
                    }
                    if (statementAdapter != null) {
                        String customValue = statementAdapter.customValue(columnName);
                        if (customValue != null) {
                            sql.append(customValue);
                        } else {
                            sql.append("?");
                        }
                    } else {
                        sql.append("?");
                    }
                    ++count;
                    continue block0;
                }
            }
        } else {
            for (int i = 0; i < this.fields.size(); ++i) {
                sql.append("?");
                if (i == this.fields.size() - 1) continue;
                sql.append(", ");
            }
        }
    }

    public void appendPrimaryKeySqL(StringBuilder sql) {
        if (this.primaryKeyFields.size() > 0) {
            sql.append("PRIMARY KEY (");
            for (EntityFieldDefinition p : this.getPrimaryKey()) {
                sql.append(p.getName());
            }
            sql.append(")");
        }
    }

    public void addField(EntityFieldDefinition field) {
        this.fields.add(field);
    }

    public void setPrimaryKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key musst not be null");
        }
        boolean found = false;
        for (EntityFieldDefinition f : this.fields) {
            if (!key.equals(f.getName())) continue;
            f.setPrimaryKeyField(true);
            this.primaryKeyFields.add(f);
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No field for key '" + key + "'found");
        }
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version musst not be null");
        }
        boolean found = false;
        for (EntityFieldDefinition f : this.fields) {
            if (!version.equals(f.getName())) continue;
            f.setVersionField(true);
            this.versionFields.add(f);
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No field for key '" + version + "'found");
        }
    }

    public void appendPrimaryKeyCriteriaSql(StringBuilder sql) {
        for (int i = 0; i < this.primaryKeyFields.size(); ++i) {
            EntityFieldDefinition f = this.primaryKeyFields.get(i);
            sql.append(f.getName() + " = ?");
            if (i == this.primaryKeyFields.size() - 1) continue;
            sql.append(", ");
        }
    }

    public void appendVersionCriteriaSql(StringBuilder sql) {
        if (this.versionFields.size() > 0) {
            sql.append(" AND ");
        }
        for (int i = 0; i < this.versionFields.size(); ++i) {
            EntityFieldDefinition f = this.versionFields.get(i);
            sql.append(f.getName() + " = ?");
            if (i == this.versionFields.size() - 1) continue;
            sql.append(", ");
        }
    }

    protected String columnNameForField(String fieldName, boolean supportOnlyEntityFields) {
        String columnName = this.columnNameForRecordField(fieldName);
        if (columnName == null && !supportOnlyEntityFields && (columnName = this.stringHelper.camelCaseToUnderLineSeperated(fieldName)) != null) {
            columnName = columnName.toUpperCase();
        }
        return columnName;
    }

    public String fieldNameForColumn(String columnName, String tableName) {
        String fieldName = null;
        if (this.stringHelper.hasValue(tableName) && tableName.equalsIgnoreCase(this.getName())) {
            fieldName = this.recordFieldNameForColumn(columnName);
        }
        if (fieldName == null) {
            fieldName = this.stringHelper.underLineSeperatedToCamelCase(columnName);
        }
        return fieldName;
    }

    protected boolean containsField(String fieldName) {
        if (fieldName != null) {
            for (EntityFieldDefinition dbField : this.getFields()) {
                if (!fieldName.equals(dbField.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected String columnNameForRecordField(String fieldName) {
        for (EntityFieldDefinition dbField : this.getFields()) {
            if (!fieldName.equalsIgnoreCase(dbField.objectFieldName)) continue;
            return dbField.getName();
        }
        return null;
    }

    protected EntityFieldDefinition databaseFieldForColumn(String columnName) {
        for (EntityFieldDefinition dbField : this.getFields()) {
            if (!columnName.equalsIgnoreCase(dbField.getName())) continue;
            return dbField;
        }
        return null;
    }

    protected String recordFieldNameForColumn(String columnName) {
        for (EntityFieldDefinition dbField : this.getFields()) {
            if (!columnName.equalsIgnoreCase(dbField.getName())) continue;
            return dbField.objectFieldName;
        }
        return null;
    }

    public <T> Field findField(Field[] fields, String fieldName) {
        for (Field f : fields) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public EntityFieldDefinition getDatabaseFieldForObjectFieldName(String fieldName) {
        for (EntityFieldDefinition databaseField : this.getFields()) {
            String columnName = this.columnNameForRecordField(fieldName);
            if (!databaseField.getName().equalsIgnoreCase(columnName)) continue;
            return databaseField;
        }
        throw new RuntimeException("Database field not found for field with name '" + fieldName + "' for entity '" + this.name + "'");
    }
}

